% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspector_operations.R
\name{inspector_list_findings}
\alias{inspector_list_findings}
\title{Lists findings that are generated by the assessment runs that are
specified by the ARNs of the assessment runs}
\usage{
inspector_list_findings(assessmentRunArns, filter, nextToken,
  maxResults)
}
\arguments{
\item{assessmentRunArns}{The ARNs of the assessment runs that generate the findings that you want
to list.}

\item{filter}{You can use this parameter to specify a subset of data to be included in
the action\'s response.

For a record to match a filter, all specified filter attributes must
match. When multiple values are specified for a filter attribute, any of
the values can match.}

\item{nextToken}{You can use this parameter when paginating results. Set the value of
this parameter to null on your first call to the \strong{ListFindings}
action. Subsequent calls to the action fill \strong{nextToken} in the request
with the value of \strong{NextToken} from the previous response to continue
listing data.}

\item{maxResults}{You can use this parameter to indicate the maximum number of items you
want in the response. The default value is 10. The maximum value is 500.}
}
\description{
Lists findings that are generated by the assessment runs that are
specified by the ARNs of the assessment runs.
}
\section{Request syntax}{
\preformatted{svc$list_findings(
  assessmentRunArns = list(
    "string"
  ),
  filter = list(
    agentIds = list(
      "string"
    ),
    autoScalingGroups = list(
      "string"
    ),
    ruleNames = list(
      "string"
    ),
    severities = list(
      "Low"|"Medium"|"High"|"Informational"|"Undefined"
    ),
    rulesPackageArns = list(
      "string"
    ),
    attributes = list(
      list(
        key = "string",
        value = "string"
      )
    ),
    userAttributes = list(
      list(
        key = "string",
        value = "string"
      )
    ),
    creationTimeRange = list(
      beginDate = as.POSIXct(
        "2015-01-01"
      ),
      endDate = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  nextToken = "string",
  maxResults = 123
)
}
}

\examples{
# Lists findings that are generated by the assessment runs that are
# specified by the ARNs of the assessment runs.
\dontrun{svc$list_findings(
  assessmentRunArns = list(
    "arn:aws:inspector:us-west-2:123456789012:target/0-0kFIPusq/template/0-4r1V2mAw/run/0-MK..."
  ),
  maxResults = 123L
)}

}
\keyword{internal}
