% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directoryservice_operations.R
\name{directoryservice_create_directory}
\alias{directoryservice_create_directory}
\title{Creates a Simple AD directory}
\usage{
directoryservice_create_directory(Name, ShortName, Password,
  Description, Size, VpcSettings, Tags)
}
\arguments{
\item{Name}{[required] The fully qualified name for the directory, such as \code{corp.example.com}.}

\item{ShortName}{The NetBIOS name of the directory, such as \code{CORP}.}

\item{Password}{[required] The password for the directory administrator. The directory creation
process creates a directory administrator account with the user name
\code{Administrator} and this password.

If you need to change the password for the administrator account, you
can use the ResetUserPassword API call.}

\item{Description}{A description for the directory.}

\item{Size}{[required] The size of the directory.}

\item{VpcSettings}{A DirectoryVpcSettings object that contains additional information for
the operation.}

\item{Tags}{The tags to be assigned to the Simple AD directory.}
}
\description{
Creates a Simple AD directory. For more information, see \href{https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_simple_ad.html}{Simple Active Directory}
in the \emph{AWS Directory Service Admin Guide}.
}
\details{
Before you call \code{CreateDirectory}, ensure that all of the required
permissions have been explicitly granted through a policy. For details
about what permissions are required to run the \code{CreateDirectory}
operation, see \href{http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html}{AWS Directory Service API Permissions: Actions, Resources, and Conditions Reference}.
}
\section{Request syntax}{
\preformatted{svc$create_directory(
  Name = "string",
  ShortName = "string",
  Password = "string",
  Description = "string",
  Size = "Small"|"Large",
  VpcSettings = list(
    VpcId = "string",
    SubnetIds = list(
      "string"
    )
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
