% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acmpca_operations.R
\name{acmpca_list_permissions}
\alias{acmpca_list_permissions}
\title{Lists all the permissions, if any, that have been assigned by a private
CA}
\usage{
acmpca_list_permissions(CertificateAuthorityArn, NextToken, MaxResults)
}
\arguments{
\item{CertificateAuthorityArn}{[required] The Amazon Resource Number (ARN) of the private CA to inspect. You can
find the ARN by calling the ListCertificateAuthorities action. This must
be of the form:
\code{arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012}
You can get a private CA\'s ARN by running the
ListCertificateAuthorities action.}

\item{NextToken}{When paginating results, use this parameter in a subsequent request
after you receive a response with truncated results. Set it to the value
of \strong{NextToken} from the response you just received.}

\item{MaxResults}{When paginating results, use this parameter to specify the maximum
number of items to return in the response. If additional items exist
beyond the number you specify, the \strong{NextToken} element is sent in the
response. Use this \strong{NextToken} value in a subsequent request to
retrieve additional items.}
}
\description{
Lists all the permissions, if any, that have been assigned by a private
CA. Permissions can be granted with the CreatePermission action and
revoked with the DeletePermission action.
}
\section{Request syntax}{
\preformatted{svc$list_permissions(
  CertificateAuthorityArn = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
