% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ram_operations.R
\name{ram_list_resources}
\alias{ram_list_resources}
\title{Lists the resources that you added to a resource shares or the resources
that are shared with you}
\usage{
ram_list_resources(resourceOwner, principal, resourceType, resourceArns,
  resourceShareArns, nextToken, maxResults)
}
\arguments{
\item{resourceOwner}{[required] The type of owner.}

\item{principal}{The principal.}

\item{resourceType}{The resource type.

Valid values: \code{ec2:CapacityReservation} \\| \code{ec2:Subnet} \\|
\code{ec2:TrafficMirrorTarget} \\| \code{ec2:TransitGateway} \\|
\code{license-manager:LicenseConfiguration} \\| \code{rds:Cluster} \\|
\code{route53resolver:ResolverRule} \\| \code{resource-groups:Group}}

\item{resourceArns}{The Amazon Resource Names (ARN) of the resources.}

\item{resourceShareArns}{The Amazon Resource Names (ARN) of the resource shares.}

\item{nextToken}{The token for the next page of results.}

\item{maxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}
}
\description{
Lists the resources that you added to a resource shares or the resources
that are shared with you.
}
\section{Request syntax}{
\preformatted{svc$list_resources(
  resourceOwner = "SELF"|"OTHER-ACCOUNTS",
  principal = "string",
  resourceType = "string",
  resourceArns = list(
    "string"
  ),
  resourceShareArns = list(
    "string"
  ),
  nextToken = "string",
  maxResults = 123
)
}
}

\keyword{internal}
