% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ram_operations.R
\name{ram_get_resource_share_associations}
\alias{ram_get_resource_share_associations}
\title{Gets the associations for the specified resource share}
\usage{
ram_get_resource_share_associations(associationType, resourceShareArns,
  resourceArn, principal, associationStatus, nextToken, maxResults)
}
\arguments{
\item{associationType}{[required] The association type.}

\item{resourceShareArns}{The Amazon Resource Names (ARN) of the resource shares.}

\item{resourceArn}{The Amazon Resource Name (ARN) of the resource.}

\item{principal}{The principal.}

\item{associationStatus}{The status of the association.}

\item{nextToken}{The token for the next page of results.}

\item{maxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}
}
\description{
Gets the associations for the specified resource share.
}
\section{Request syntax}{
\preformatted{svc$get_resource_share_associations(
  associationType = "PRINCIPAL"|"RESOURCE",
  resourceShareArns = list(
    "string"
  ),
  resourceArn = "string",
  principal = "string",
  associationStatus = "ASSOCIATING"|"ASSOCIATED"|"FAILED"|"DISASSOCIATING"|"DISASSOCIATED",
  nextToken = "string",
  maxResults = 123
)
}
}

\keyword{internal}
