% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_get_parameters_for_import}
\alias{kms_get_parameters_for_import}
\title{Returns the items you need in order to import key material into AWS KMS
from your existing key management infrastructure}
\usage{
kms_get_parameters_for_import(KeyId, WrappingAlgorithm, WrappingKeySpec)
}
\arguments{
\item{KeyId}{[required] The identifier of the CMK into which you will import key material. The
CMK's \code{Origin} must be \code{EXTERNAL}.

Specify the key ID or the Amazon Resource Name (ARN) of the CMK.

For example:
\itemize{
\item Key ID: \code{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\code{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.}

\item{WrappingAlgorithm}{[required] The algorithm you will use to encrypt the key material before importing
it with ImportKeyMaterial. For more information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-encrypt-key-material.html}{Encrypt the Key Material}
in the \emph{AWS Key Management Service Developer Guide}.}

\item{WrappingKeySpec}{[required] The type of wrapping key (public key) to return in the response. Only
2048-bit RSA public keys are supported.}
}
\description{
Returns the items you need in order to import key material into AWS KMS
from your existing key management infrastructure. For more information
about importing key material into AWS KMS, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html}{Importing Key Material}
in the \emph{AWS Key Management Service Developer Guide}.
}
\details{
You must specify the key ID of the customer master key (CMK) into which
you will import key material. This CMK's \code{Origin} must be \code{EXTERNAL}.
You must also specify the wrapping algorithm and type of wrapping key
(public key) that you will use to encrypt the key material. You cannot
perform this operation on a CMK in a different AWS account.

This operation returns a public key and an import token. Use the public
key to encrypt the key material. Store the import token to send with a
subsequent ImportKeyMaterial request. The public key and import token
from the same response must be used together. These items are valid for
24 hours. When they expire, they cannot be used for a subsequent
ImportKeyMaterial request. To get new ones, send another
\code{GetParametersForImport} request.

The result of this operation varies with the key state of the CMK. For
details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html}{How Key State Affects Use of a Customer Master Key}
in the \emph{AWS Key Management Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$get_parameters_for_import(
  KeyId = "string",
  WrappingAlgorithm = "RSAES_PKCS1_V1_5"|"RSAES_OAEP_SHA_1"|"RSAES_OAEP_SHA_256",
  WrappingKeySpec = "RSA_2048"
)
}
}

\examples{
# The following example retrieves the public key and import token for the
# specified CMK.
\donttest{svc$get_parameters_for_import(
  KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab",
  WrappingAlgorithm = "RSAES_OAEP_SHA_1",
  WrappingKeySpec = "RSA_2048"
)}

}
\keyword{internal}
