% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitosync_operations.R
\name{cognitosync_register_device}
\alias{cognitosync_register_device}
\title{Registers a device to receive push sync notifications}
\usage{
cognitosync_register_device(IdentityPoolId, IdentityId, Platform, Token)
}
\arguments{
\item{IdentityPoolId}{[required] A name-spaced GUID (for example,
us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
Cognito. Here, the ID of the pool that the identity belongs to.}

\item{IdentityId}{[required] The unique ID for this identity.}

\item{Platform}{[required] The SNS platform type (e.g. GCM, SDM, APNS, APNS\_SANDBOX).}

\item{Token}{[required] The push token.}
}
\description{
Registers a device to receive push sync notifications.
}
\details{
This API can only be called with temporary credentials provided by
Cognito Identity. You cannot call this API with developer credentials.
}
\section{Request syntax}{
\preformatted{svc$register_device(
  IdentityPoolId = "string",
  IdentityId = "string",
  Platform = "APNS"|"APNS_SANDBOX"|"GCM"|"ADM",
  Token = "string"
)
}
}

\keyword{internal}
