% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_update_byte_match_set}
\alias{wafregional_update_byte_match_set}
\title{This is AWS WAF Classic documentation}
\usage{
wafregional_update_byte_match_set(ByteMatchSetId, ChangeToken, Updates)
}
\arguments{
\item{ByteMatchSetId}{[required] The \code{ByteMatchSetId} of the ByteMatchSet that you want to update.
\code{ByteMatchSetId} is returned by
\code{\link[=wafregional_create_byte_match_set]{create_byte_match_set}} and by
\code{\link[=wafregional_list_byte_match_sets]{list_byte_match_sets}}.}

\item{ChangeToken}{[required] The value returned by the most recent call to
\code{\link[=wafregional_get_change_token]{get_change_token}}.}

\item{Updates}{[required] An array of \code{ByteMatchSetUpdate} objects that you want to insert into or
delete from a ByteMatchSet. For more information, see the applicable
data types:
\itemize{
\item ByteMatchSetUpdate: Contains \code{Action} and \code{ByteMatchTuple}
\item ByteMatchTuple: Contains \code{FieldToMatch}, \code{PositionalConstraint},
\code{TargetString}, and \code{TextTransformation}
\item FieldToMatch: Contains \code{Data} and \code{Type}
}}
}
\value{
A list with the following syntax:\preformatted{list(
  ChangeToken = "string"
)
}
}
\description{
This is \strong{AWS WAF Classic} documentation. For more information, see
\href{https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html}{AWS WAF Classic}
in the developer guide.

\strong{For the latest version of AWS WAF}, use the AWS WAFV2 API and see the
\href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html}{AWS WAF Developer Guide}.
With the latest version, AWS WAF has a single set of endpoints for
regional and global use.

Inserts or deletes ByteMatchTuple objects (filters) in a ByteMatchSet.
For each \code{ByteMatchTuple} object, you specify the following values:
\itemize{
\item Whether to insert or delete the object from the array. If you want
to change a \code{ByteMatchSetUpdate} object, you delete the existing
object and add a new one.
\item The part of a web request that you want AWS WAF to inspect, such as
a query string or the value of the \code{User-Agent} header.
\item The bytes (typically a string that corresponds with ASCII
characters) that you want AWS WAF to look for. For more information,
including how you specify the values for the AWS WAF API and the AWS
CLI or SDKs, see \code{TargetString} in the ByteMatchTuple data type.
\item Where to look, such as at the beginning or the end of a query
string.
\item Whether to perform any conversions on the request, such as
converting it to lowercase, before inspecting it for the specified
string.
}

For example, you can add a \code{ByteMatchSetUpdate} object that matches web
requests in which \code{User-Agent} headers contain the string \code{BadBot}. You
can then configure AWS WAF to block those requests.

To create and configure a \code{ByteMatchSet}, perform the following steps:
\enumerate{
\item Create a \code{ByteMatchSet.} For more information, see
\code{\link[=wafregional_create_byte_match_set]{create_byte_match_set}}.
\item Use \code{\link[=wafregional_get_change_token]{get_change_token}} to get the
change token that you provide in the \code{ChangeToken} parameter of an
\code{\link[=wafregional_update_byte_match_set]{update_byte_match_set}}
request.
\item Submit an
\code{\link[=wafregional_update_byte_match_set]{update_byte_match_set}} request
to specify the part of the request that you want AWS WAF to inspect
(for example, the header or the URI) and the value that you want AWS
WAF to watch for.
}

For more information about how to use the AWS WAF API to allow or block
HTTP requests, see the \href{https://docs.aws.amazon.com/waf/latest/developerguide/}{AWS WAF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$update_byte_match_set(
  ByteMatchSetId = "string",
  ChangeToken = "string",
  Updates = list(
    list(
      Action = "INSERT"|"DELETE",
      ByteMatchTuple = list(
        FieldToMatch = list(
          Type = "URI"|"QUERY_STRING"|"HEADER"|"METHOD"|"BODY"|"SINGLE_QUERY_ARG"|"ALL_QUERY_ARGS",
          Data = "string"
        ),
        TargetString = raw,
        TextTransformation = "NONE"|"COMPRESS_WHITE_SPACE"|"HTML_ENTITY_DECODE"|"LOWERCASE"|"CMD_LINE"|"URL_DECODE",
        PositionalConstraint = "EXACTLY"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CONTAINS_WORD"
      )
    )
  )
)
}
}

\examples{
\dontrun{
# The following example deletes a ByteMatchTuple object (filters) in an
# byte match set with the ID exampleIDs3t-46da-4fdb-b8d5-abc321j569j5.
svc$update_byte_match_set(
  ByteMatchSetId = "exampleIDs3t-46da-4fdb-b8d5-abc321j569j5",
  ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
  Updates = list(
    list(
      Action = "DELETE",
      ByteMatchTuple = list(
        FieldToMatch = list(
          Data = "referer",
          Type = "HEADER"
        ),
        PositionalConstraint = "CONTAINS",
        TargetString = "badrefer1",
        TextTransformation = "NONE"
      )
    )
  )
)
}

}
\keyword{internal}
