% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_describe_key}
\alias{kms_describe_key}
\title{Provides detailed information about a customer master key (CMK)}
\usage{
kms_describe_key(KeyId, GrantTokens)
}
\arguments{
\item{KeyId}{[required] Describes the specified customer master key (CMK).

If you specify a predefined AWS alias (an AWS alias with no key ID), KMS
associates the alias with an \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys}{AWS managed CMK}
and returns its \code{KeyId} and \code{Arn} in the response.

To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias
name, or alias ARN. When using an alias name, prefix it with \code{"alias/"}.
To specify a CMK in a different AWS account, you must use the key ARN or
alias ARN.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
\item Alias name: \code{alias/ExampleAlias}
\item Alias ARN: \code{arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias}
}

To get the key ID and key ARN for a CMK, use
\code{\link[=kms_list_keys]{list_keys}} or \code{\link[=kms_describe_key]{describe_key}}. To
get the alias name and alias ARN, use
\code{\link[=kms_list_aliases]{list_aliases}}.}

\item{GrantTokens}{A list of grant tokens.

For more information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token}{Grant Tokens}
in the \emph{AWS Key Management Service Developer Guide}.}
}
\value{
A list with the following syntax:\preformatted{list(
  KeyMetadata = list(
    AWSAccountId = "string",
    KeyId = "string",
    Arn = "string",
    CreationDate = as.POSIXct(
      "2015-01-01"
    ),
    Enabled = TRUE|FALSE,
    Description = "string",
    KeyUsage = "SIGN_VERIFY"|"ENCRYPT_DECRYPT",
    KeyState = "Enabled"|"Disabled"|"PendingDeletion"|"PendingImport"|"Unavailable",
    DeletionDate = as.POSIXct(
      "2015-01-01"
    ),
    ValidTo = as.POSIXct(
      "2015-01-01"
    ),
    Origin = "AWS_KMS"|"EXTERNAL"|"AWS_CLOUDHSM",
    CustomKeyStoreId = "string",
    CloudHsmClusterId = "string",
    ExpirationModel = "KEY_MATERIAL_EXPIRES"|"KEY_MATERIAL_DOES_NOT_EXPIRE",
    KeyManager = "AWS"|"CUSTOMER",
    CustomerMasterKeySpec = "RSA_2048"|"RSA_3072"|"RSA_4096"|"ECC_NIST_P256"|"ECC_NIST_P384"|"ECC_NIST_P521"|"ECC_SECG_P256K1"|"SYMMETRIC_DEFAULT",
    EncryptionAlgorithms = list(
      "SYMMETRIC_DEFAULT"|"RSAES_OAEP_SHA_1"|"RSAES_OAEP_SHA_256"
    ),
    SigningAlgorithms = list(
      "RSASSA_PSS_SHA_256"|"RSASSA_PSS_SHA_384"|"RSASSA_PSS_SHA_512"|"RSASSA_PKCS1_V1_5_SHA_256"|"RSASSA_PKCS1_V1_5_SHA_384"|"RSASSA_PKCS1_V1_5_SHA_512"|"ECDSA_SHA_256"|"ECDSA_SHA_384"|"ECDSA_SHA_512"
    )
  )
)
}
}
\description{
Provides detailed information about a customer master key (CMK). You can
run \code{\link[=kms_describe_key]{describe_key}} on a \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk}{customer managed CMK}
or an \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk}{AWS managed CMK}.

This detailed information includes the key ARN, creation date (and
deletion date, if applicable), the key state, and the origin and
expiration date (if any) of the key material. For CMKs in custom key
stores, it includes information about the custom key store, such as the
key store ID and the AWS CloudHSM cluster ID. It includes fields, like
\code{KeySpec}, that help you distinguish symmetric from asymmetric CMKs. It
also provides information that is particularly important to asymmetric
CMKs, such as the key usage (encryption or signing) and the encryption
algorithms or signing algorithms that the CMK supports.

\code{\link[=kms_describe_key]{describe_key}} does not return the following
information:
\itemize{
\item Aliases associated with the CMK. To get this information, use
\code{\link[=kms_list_aliases]{list_aliases}}.
\item Whether automatic key rotation is enabled on the CMK. To get this
information, use
\code{\link[=kms_get_key_rotation_status]{get_key_rotation_status}}. Also, some
key states prevent a CMK from being automatically rotated. For
details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html#rotate-keys-how-it-works}{How Automatic Key Rotation Works}
in \emph{AWS Key Management Service Developer Guide}.
\item Tags on the CMK. To get this information, use
\code{\link[=kms_list_resource_tags]{list_resource_tags}}.
\item Key policies and grants on the CMK. To get this information, use
\code{\link[=kms_get_key_policy]{get_key_policy}} and
\code{\link[=kms_list_grants]{list_grants}}.
}

If you call the \code{\link[=kms_describe_key]{describe_key}} operation on a
\emph{predefined AWS alias}, that is, an AWS alias with no key ID, AWS KMS
creates an \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys}{AWS managed CMK}.
Then, it associates the alias with the new CMK, and returns the \code{KeyId}
and \code{Arn} of the new CMK in the response.

\strong{Cross-account use}: Yes. To perform this operation with a CMK in a
different AWS account, specify the key ARN or alias ARN in the value of
the \code{KeyId} parameter.

\strong{Required permissions}:
\href{https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html}{kms:DescribeKey}
(key policy)

\strong{Related operations:}
\itemize{
\item \code{\link[=kms_get_key_policy]{get_key_policy}}
\item \code{\link[=kms_get_key_rotation_status]{get_key_rotation_status}}
\item \code{\link[=kms_list_aliases]{list_aliases}}
\item \code{\link[=kms_list_grants]{list_grants}}
\item \code{\link[=kms_list_keys]{list_keys}}
\item \code{\link[=kms_list_resource_tags]{list_resource_tags}}
\item \code{\link[=kms_list_retirable_grants]{list_retirable_grants}}
}
}
\section{Request syntax}{
\preformatted{svc$describe_key(
  KeyId = "string",
  GrantTokens = list(
    "string"
  )
)
}
}

\examples{
\dontrun{
# The following example returns information (metadata) about the specified
# CMK.
svc$describe_key(
  KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
)
}

}
\keyword{internal}
