% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_update_group}
\alias{iam_update_group}
\title{Updates the name and/or the path of the specified IAM group}
\usage{
iam_update_group(GroupName, NewPath, NewGroupName)
}
\arguments{
\item{GroupName}{[required] Name of the IAM group to update. If you're changing the name of the
group, this is the original name.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{NewPath}{New path for the IAM group. Only include this if changing the group's
path.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of either a forward slash (/) by itself or a string that must
begin and end with forward slashes. In addition, it can contain any
ASCII character from the ! (\verb{\\u0021}) through the DEL character
(\verb{\\u007F}), including most punctuation characters, digits, and upper and
lowercased letters.}

\item{NewGroupName}{New name for the IAM group. Only include this if changing the group's
name.

IAM user, group, role, and policy names must be unique within the
account. Names are not distinguished by case. For example, you cannot
create resources named both "MyResource" and "myresource".}
}
\value{
An empty list.
}
\description{
Updates the name and/or the path of the specified IAM group.

You should understand the implications of changing a group's path or
name. For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id.html}{Renaming Users and Groups} in the
\emph{IAM User Guide}.

The person making the request (the principal), must have permission to
change the role group with the old name and the new name. For example,
to change the group named \code{Managers} to \code{MGRs}, the principal must have
a policy that allows them to update both groups. If the principal has
permission to update the \code{Managers} group, but not the \code{MGRs} group,
then the update fails. For more information about permissions, see
\href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html}{Access Management}.
}
\section{Request syntax}{
\preformatted{svc$update_group(
  GroupName = "string",
  NewPath = "string",
  NewGroupName = "string"
)
}
}

\examples{
\dontrun{
# The following command changes the name of the IAM group Test to Test-1.
svc$update_group(
  GroupName = "Test",
  NewGroupName = "Test-1"
)
}

}
\keyword{internal}
