% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directoryservice_operations.R
\name{directoryservice_update_number_of_domain_controllers}
\alias{directoryservice_update_number_of_domain_controllers}
\title{Adds or removes domain controllers to or from the directory}
\usage{
directoryservice_update_number_of_domain_controllers(DirectoryId,
  DesiredNumber)
}
\arguments{
\item{DirectoryId}{[required] Identifier of the directory to which the domain controllers will be
added or removed.}

\item{DesiredNumber}{[required] The number of domain controllers desired in the directory.}
}
\value{
An empty list.
}
\description{
Adds or removes domain controllers to or from the directory. Based on
the difference between current value and new value (provided through
this API call), domain controllers will be added or removed. It may take
up to 45 minutes for any new domain controllers to become fully active
once the requested number of domain controllers is updated. During this
time, you cannot make another update request.
}
\section{Request syntax}{
\preformatted{svc$update_number_of_domain_controllers(
  DirectoryId = "string",
  DesiredNumber = 123
)
}
}

\keyword{internal}
