% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentity_operations.R
\name{cognitoidentity_get_credentials_for_identity}
\alias{cognitoidentity_get_credentials_for_identity}
\title{Returns credentials for the provided identity ID}
\usage{
cognitoidentity_get_credentials_for_identity(IdentityId, Logins,
  CustomRoleArn)
}
\arguments{
\item{IdentityId}{[required] A unique identifier in the format REGION:GUID.}

\item{Logins}{A set of optional name-value pairs that map provider names to provider
tokens. The name-value pair will follow the syntax "provider_name":
"provider_user_identifier".

Logins should not be specified when trying to get credentials for an
unauthenticated identity.

The Logins parameter is required when using identities associated with
external identity providers such as FaceBook. For examples of \code{Logins}
maps, see the code examples in the \href{https://docs.aws.amazon.com/cognito/latest/developerguide/external-identity-providers.html}{External Identity Providers}
section of the Amazon Cognito Developer Guide.}

\item{CustomRoleArn}{The Amazon Resource Name (ARN) of the role to be assumed when multiple
roles were received in the token from the identity provider. For
example, a SAML-based identity provider. This parameter is optional for
identity providers that do not support role customization.}
}
\value{
A list with the following syntax:\preformatted{list(
  IdentityId = "string",
  Credentials = list(
    AccessKeyId = "string",
    SecretKey = "string",
    SessionToken = "string",
    Expiration = as.POSIXct(
      "2015-01-01"
    )
  )
)
}
}
\description{
Returns credentials for the provided identity ID. Any provided logins
will be validated against supported login providers. If the token is for
cognito-identity.amazonaws.com, it will be passed through to AWS
Security Token Service with the appropriate role for the token.

This is a public API. You do not need any credentials to call this API.
}
\section{Request syntax}{
\preformatted{svc$get_credentials_for_identity(
  IdentityId = "string",
  Logins = list(
    "string"
  ),
  CustomRoleArn = "string"
)
}
}

\keyword{internal}
