% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_generate_data_key_without_plaintext}
\alias{kms_generate_data_key_without_plaintext}
\title{Returns a data encryption key encrypted under a customer master key
(CMK)}
\usage{
kms_generate_data_key_without_plaintext(KeyId, EncryptionContext,
  KeySpec, NumberOfBytes, GrantTokens)
}
\arguments{
\item{KeyId}{[required] The identifier of the customer master key (CMK) under which to generate
and encrypt the data encryption key.

To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias
name, or alias ARN. When using an alias name, prefix it with "alias/".
To specify a CMK in a different AWS account, you must use the key ARN or
alias ARN.

For example:
\itemize{
\item Key ID: \code{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\code{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
\item Alias name: \code{alias/ExampleAlias}
\item Alias ARN: \code{arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias}
}

To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
get the alias name and alias ARN, use ListAliases.}

\item{EncryptionContext}{A set of key-value pairs that represents additional authenticated data.

For more information, see \href{http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html}{Encryption Context}
in the \emph{AWS Key Management Service Developer Guide}.}

\item{KeySpec}{The length of the data encryption key. Use \code{AES_128} to generate a
128-bit symmetric key, or \code{AES_256} to generate a 256-bit symmetric key.}

\item{NumberOfBytes}{The length of the data encryption key in bytes. For example, use the
value 64 to generate a 512-bit data key (64 bytes is 512 bits). For
common key lengths (128-bit and 256-bit symmetric keys), we recommend
that you use the \code{KeySpec} field instead of this one.}

\item{GrantTokens}{A list of grant tokens.

For more information, see \href{http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token}{Grant Tokens}
in the \emph{AWS Key Management Service Developer Guide}.}
}
\description{
Returns a data encryption key encrypted under a customer master key
(CMK). This operation is identical to GenerateDataKey but returns only
the encrypted copy of the data key.
}
\details{
To perform this operation on a CMK in a different AWS account, specify
the key ARN or alias ARN in the value of the KeyId parameter.

This operation is useful in a system that has multiple components with
different degrees of trust. For example, consider a system that stores
encrypted data in containers. Each container stores the encrypted data
and an encrypted copy of the data key. One component of the system,
called the \emph{control plane}, creates new containers. When it creates a
new container, it uses this operation
(\code{GenerateDataKeyWithoutPlaintext}) to get an encrypted data key and
then stores it in the container. Later, a different component of the
system, called the \emph{data plane}, puts encrypted data into the
containers. To do this, it passes the encrypted data key to the Decrypt
operation, then uses the returned plaintext data key to encrypt data,
and finally stores the encrypted data in the container. In this system,
the control plane never sees the plaintext data key.

The result of this operation varies with the key state of the CMK. For
details, see \href{http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html}{How Key State Affects Use of a Customer Master Key}
in the \emph{AWS Key Management Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$generate_data_key_without_plaintext(
  KeyId = "string",
  EncryptionContext = list(
    "string"
  ),
  KeySpec = "AES_256"|"AES_128",
  NumberOfBytes = 123,
  GrantTokens = list(
    "string"
  )
)
}
}

\examples{
# The following example generates an encrypted copy of a 256-bit symmetric
# data encryption key (data key). The data key is encrypted with the
# specified customer master key (CMK).
\donttest{svc$generate_data_key_without_plaintext(
  KeyId = "alias/ExampleAlias",
  KeySpec = "AES_256"
)}

}
\keyword{internal}
