% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_list_policies}
\alias{iam_list_policies}
\title{Lists all the managed policies that are available in your AWS account,
including your own customer-defined managed policies and all AWS managed
policies}
\usage{
iam_list_policies(Scope, OnlyAttached, PathPrefix, PolicyUsageFilter,
  Marker, MaxItems)
}
\arguments{
\item{Scope}{The scope to use for filtering the results.

To list only AWS managed policies, set \code{Scope} to \code{AWS}. To list only
the customer managed policies in your AWS account, set \code{Scope} to
\code{Local}.

This parameter is optional. If it is not included, or if it is set to
\code{All}, all policies are returned.}

\item{OnlyAttached}{A flag to filter the results to only the attached policies.

When \code{OnlyAttached} is \code{true}, the returned list contains only the
policies that are attached to an IAM user, group, or role. When
\code{OnlyAttached} is \code{false}, or when the parameter is not included, all
policies are returned.}

\item{PathPrefix}{The path prefix for filtering the results. This parameter is optional.
If it is not included, it defaults to a slash (/), listing all policies.
This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters
consisting of either a forward slash (/) by itself or a string that must
begin and end with forward slashes. In addition, it can contain any
ASCII character from the ! (\code{U+0021}) through the DEL character
(\code{U+007F}), including most punctuation characters, digits, and upper and
lowercased letters.}

\item{PolicyUsageFilter}{The policy usage method to use for filtering the results.

To list only permissions policies,
setÂ \code{PolicyUsageFilter}Â toÂ \code{PermissionsPolicy}. To list only the
policies used to set permissions boundaries, setÂ the value
toÂ \code{PermissionsBoundary}.

This parameter is optional. If it is not included, all policies are
returned.}

\item{Marker}{Use this parameter only when paginating results and only after you
receive a response indicating that the results are truncated. Set it to
the value of the \code{Marker} element in the response that you received to
indicate where the next call should start.}

\item{MaxItems}{Use this only when paginating results to indicate the maximum number of
items you want in the response. If additional items exist beyond the
maximum you specify, the \code{IsTruncated} response element is \code{true}.

If you do not include this parameter, the number of items defaults to
100. Note that IAM might return fewer results, even when there are more
results available. In that case, the \code{IsTruncated} response element
returns \code{true}, and \code{Marker} contains a value to include in the
subsequent call that tells the service where to continue from.}
}
\description{
Lists all the managed policies that are available in your AWS account,
including your own customer-defined managed policies and all AWS managed
policies.
}
\details{
You can filter the list of policies that is returned using the optional
\code{OnlyAttached}, \code{Scope}, and \code{PathPrefix} parameters. For example, to
list only the customer managed policies in your AWS account, set \code{Scope}
to \code{Local}. To list only AWS managed policies, set \code{Scope} to \code{AWS}.

You can paginate the results using the \code{MaxItems} and \code{Marker}
parameters.

For more information about managed policies, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html}{Managed Policies and Inline Policies}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$list_policies(
  Scope = "All"|"AWS"|"Local",
  OnlyAttached = TRUE|FALSE,
  PathPrefix = "string",
  PolicyUsageFilter = "PermissionsPolicy"|"PermissionsBoundary",
  Marker = "string",
  MaxItems = 123
)
}
}

\keyword{internal}
