% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_delete_role}
\alias{iam_delete_role}
\title{Deletes the specified role}
\usage{
iam_delete_role(RoleName)
}
\arguments{
\item{RoleName}{[required] The name of the role to delete.

This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \_+=,.@-}
}
\description{
Deletes the specified role. The role must not have any policies
attached. For more information about roles, go to \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html}{Working with Roles}.
}
\details{
Make sure that you do not have any Amazon EC2 instances running with the
role you are about to delete. Deleting a role or instance profile that
is associated with a running instance will break any applications
running on the instance.
}
\section{Request syntax}{
\preformatted{svc$delete_role(
  RoleName = "string"
)
}
}

\examples{
# The following command removes the role named Test-Role.
\donttest{svc$delete_role(
  RoleName = "Test-Role"
)}

}
\keyword{internal}
