% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guardduty_operations.R
\name{guardduty_create_filter}
\alias{guardduty_create_filter}
\title{Creates a filter using the specified finding criteria}
\usage{
guardduty_create_filter(Action, ClientToken, Description, DetectorId,
  FindingCriteria, Name, Rank)
}
\arguments{
\item{Action}{Specifies the action that is to be applied to the findings that match the filter.}

\item{ClientToken}{The idempotency token for the create request.}

\item{Description}{The description of the filter.}

\item{DetectorId}{[required] The unique ID of the detector that you want to update.}

\item{FindingCriteria}{[required] Represents the criteria to be used in the filter for querying findings.}

\item{Name}{[required] The name of the filter.}

\item{Rank}{Specifies the position of the filter in the list of current filters. Also specifies the order in which this filter is applied to the findings.}
}
\description{
Creates a filter using the specified finding criteria.
}
\section{Request syntax}{
\preformatted{svc$create_filter(
  Action = "NOOP"|"ARCHIVE",
  ClientToken = "string",
  Description = "string",
  DetectorId = "string",
  FindingCriteria = list(
    Criterion = list(
      list(
        Eq = list(
          "string"
        ),
        Gt = 123,
        Gte = 123,
        Lt = 123,
        Lte = 123,
        Neq = list(
          "string"
        )
      )
    )
  ),
  Name = "string",
  Rank = 123
)
}
}

\keyword{internal}
