# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include appfabric_service.R
NULL

#' Gets user access details in a batch request
#'
#' @description
#' Gets user access details in a batch request.
#'
#' See [https://www.paws-r-sdk.com/docs/appfabric_batch_get_user_access_tasks/](https://www.paws-r-sdk.com/docs/appfabric_batch_get_user_access_tasks/) for full documentation.
#'
#' @param appBundleIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the app bundle to use for the request.
#' @param taskIdList &#91;required&#93; The tasks IDs to use for the request.
#'
#' @keywords internal
#'
#' @rdname appfabric_batch_get_user_access_tasks
appfabric_batch_get_user_access_tasks <- function(appBundleIdentifier, taskIdList) {
  op <- new_operation(
    name = "BatchGetUserAccessTasks",
    http_method = "POST",
    http_path = "/useraccess/batchget",
    paginator = list()
  )
  input <- .appfabric$batch_get_user_access_tasks_input(appBundleIdentifier = appBundleIdentifier, taskIdList = taskIdList)
  output <- .appfabric$batch_get_user_access_tasks_output()
  config <- get_config()
  svc <- .appfabric$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appfabric$operations$batch_get_user_access_tasks <- appfabric_batch_get_user_access_tasks

#' Establishes a connection between Amazon Web Services AppFabric and an
#' application, which allows AppFabric to call the APIs of the application
#'
#' @description
#' Establishes a connection between Amazon Web Services AppFabric and an application, which allows AppFabric to call the APIs of the application.
#'
#' See [https://www.paws-r-sdk.com/docs/appfabric_connect_app_authorization/](https://www.paws-r-sdk.com/docs/appfabric_connect_app_authorization/) for full documentation.
#'
#' @param appBundleIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the app bundle that contains the app authorization to use for the
#' request.
#' @param appAuthorizationIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the app authorization to use for the request.
#' @param authRequest Contains OAuth2 authorization information.
#' 
#' This is required if the app authorization for the request is configured
#' with an OAuth2 (`oauth2`) authorization type.
#'
#' @keywords internal
#'
#' @rdname appfabric_connect_app_authorization
appfabric_connect_app_authorization <- function(appBundleIdentifier, appAuthorizationIdentifier, authRequest = NULL) {
  op <- new_operation(
    name = "ConnectAppAuthorization",
    http_method = "POST",
    http_path = "/appbundles/{appBundleIdentifier}/appauthorizations/{appAuthorizationIdentifier}/connect",
    paginator = list()
  )
  input <- .appfabric$connect_app_authorization_input(appBundleIdentifier = appBundleIdentifier, appAuthorizationIdentifier = appAuthorizationIdentifier, authRequest = authRequest)
  output <- .appfabric$connect_app_authorization_output()
  config <- get_config()
  svc <- .appfabric$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appfabric$operations$connect_app_authorization <- appfabric_connect_app_authorization

#' Creates an app authorization within an app bundle, which allows
#' AppFabric to connect to an application
#'
#' @description
#' Creates an app authorization within an app bundle, which allows AppFabric to connect to an application.
#'
#' See [https://www.paws-r-sdk.com/docs/appfabric_create_app_authorization/](https://www.paws-r-sdk.com/docs/appfabric_create_app_authorization/) for full documentation.
#'
#' @param appBundleIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the app bundle to use for the request.
#' @param app &#91;required&#93; The name of the application.
#' 
#' Valid values are:
#' 
#' -   `SLACK`
#' 
#' -   `ASANA`
#' 
#' -   `JIRA`
#' 
#' -   `M365`
#' 
#' -   `M365AUDITLOGS`
#' 
#' -   `ZOOM`
#' 
#' -   `ZENDESK`
#' 
#' -   `OKTA`
#' 
#' -   `GOOGLE`
#' 
#' -   `DROPBOX`
#' 
#' -   `SMARTSHEET`
#' 
#' -   `CISCO`
#' @param credential &#91;required&#93; Contains credentials for the application, such as an API key or OAuth2
#' client ID and secret.
#' 
#' Specify credentials that match the authorization type for your request.
#' For example, if the authorization type for your request is OAuth2
#' (`oauth2`), then you should provide only the OAuth2 credentials.
#' @param tenant &#91;required&#93; Contains information about an application tenant, such as the
#' application display name and identifier.
#' @param authType &#91;required&#93; The authorization type for the app authorization.
#' @param clientToken Specifies a unique, case-sensitive identifier that you provide to ensure
#' the idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#' 
#' If you retry the operation with the same `ClientToken`, but with
#' different parameters, the retry fails with an
#' `IdempotentParameterMismatch` error.
#' @param tags A map of the key-value pairs of the tag or tags to assign to the
#' resource.
#'
#' @keywords internal
#'
#' @rdname appfabric_create_app_authorization
appfabric_create_app_authorization <- function(appBundleIdentifier, app, credential, tenant, authType, clientToken = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateAppAuthorization",
    http_method = "POST",
    http_path = "/appbundles/{appBundleIdentifier}/appauthorizations",
    paginator = list()
  )
  input <- .appfabric$create_app_authorization_input(appBundleIdentifier = appBundleIdentifier, app = app, credential = credential, tenant = tenant, authType = authType, clientToken = clientToken, tags = tags)
  output <- .appfabric$create_app_authorization_output()
  config <- get_config()
  svc <- .appfabric$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appfabric$operations$create_app_authorization <- appfabric_create_app_authorization

#' Creates an app bundle to collect data from an application using
#' AppFabric
#'
#' @description
#' Creates an app bundle to collect data from an application using AppFabric.
#'
#' See [https://www.paws-r-sdk.com/docs/appfabric_create_app_bundle/](https://www.paws-r-sdk.com/docs/appfabric_create_app_bundle/) for full documentation.
#'
#' @param clientToken Specifies a unique, case-sensitive identifier that you provide to ensure
#' the idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#' 
#' If you retry the operation with the same `ClientToken`, but with
#' different parameters, the retry fails with an
#' `IdempotentParameterMismatch` error.
#' @param customerManagedKeyIdentifier The Amazon Resource Name (ARN) of the Key Management Service (KMS) key
#' to use to encrypt the application data. If this is not specified, an
#' Amazon Web Services owned key is used for encryption.
#' @param tags A map of the key-value pairs of the tag or tags to assign to the
#' resource.
#'
#' @keywords internal
#'
#' @rdname appfabric_create_app_bundle
appfabric_create_app_bundle <- function(clientToken = NULL, customerManagedKeyIdentifier = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateAppBundle",
    http_method = "POST",
    http_path = "/appbundles",
    paginator = list()
  )
  input <- .appfabric$create_app_bundle_input(clientToken = clientToken, customerManagedKeyIdentifier = customerManagedKeyIdentifier, tags = tags)
  output <- .appfabric$create_app_bundle_output()
  config <- get_config()
  svc <- .appfabric$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appfabric$operations$create_app_bundle <- appfabric_create_app_bundle

#' Creates a data ingestion for an application
#'
#' @description
#' Creates a data ingestion for an application.
#'
#' See [https://www.paws-r-sdk.com/docs/appfabric_create_ingestion/](https://www.paws-r-sdk.com/docs/appfabric_create_ingestion/) for full documentation.
#'
#' @param appBundleIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the app bundle to use for the request.
#' @param app &#91;required&#93; The name of the application.
#' 
#' Valid values are:
#' 
#' -   `SLACK`
#' 
#' -   `ASANA`
#' 
#' -   `JIRA`
#' 
#' -   `M365`
#' 
#' -   `M365AUDITLOGS`
#' 
#' -   `ZOOM`
#' 
#' -   `ZENDESK`
#' 
#' -   `OKTA`
#' 
#' -   `GOOGLE`
#' 
#' -   `DROPBOX`
#' 
#' -   `SMARTSHEET`
#' 
#' -   `CISCO`
#' @param tenantId &#91;required&#93; The ID of the application tenant.
#' @param ingestionType &#91;required&#93; The ingestion type.
#' @param clientToken Specifies a unique, case-sensitive identifier that you provide to ensure
#' the idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#' 
#' If you retry the operation with the same `ClientToken`, but with
#' different parameters, the retry fails with an
#' `IdempotentParameterMismatch` error.
#' @param tags A map of the key-value pairs of the tag or tags to assign to the
#' resource.
#'
#' @keywords internal
#'
#' @rdname appfabric_create_ingestion
appfabric_create_ingestion <- function(appBundleIdentifier, app, tenantId, ingestionType, clientToken = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateIngestion",
    http_method = "POST",
    http_path = "/appbundles/{appBundleIdentifier}/ingestions",
    paginator = list()
  )
  input <- .appfabric$create_ingestion_input(appBundleIdentifier = appBundleIdentifier, app = app, tenantId = tenantId, ingestionType = ingestionType, clientToken = clientToken, tags = tags)
  output <- .appfabric$create_ingestion_output()
  config <- get_config()
  svc <- .appfabric$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appfabric$operations$create_ingestion <- appfabric_create_ingestion

#' Creates an ingestion destination, which specifies how an application's
#' ingested data is processed by Amazon Web Services AppFabric and where
#' it's delivered
#'
#' @description
#' Creates an ingestion destination, which specifies how an application's ingested data is processed by Amazon Web Services AppFabric and where it's delivered.
#'
#' See [https://www.paws-r-sdk.com/docs/appfabric_create_ingestion_destination/](https://www.paws-r-sdk.com/docs/appfabric_create_ingestion_destination/) for full documentation.
#'
#' @param appBundleIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the app bundle to use for the request.
#' @param ingestionIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the ingestion to use for the request.
#' @param processingConfiguration &#91;required&#93; Contains information about how ingested data is processed.
#' @param destinationConfiguration &#91;required&#93; Contains information about the destination of ingested data.
#' @param clientToken Specifies a unique, case-sensitive identifier that you provide to ensure
#' the idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#' 
#' If you retry the operation with the same `ClientToken`, but with
#' different parameters, the retry fails with an
#' `IdempotentParameterMismatch` error.
#' @param tags A map of the key-value pairs of the tag or tags to assign to the
#' resource.
#'
#' @keywords internal
#'
#' @rdname appfabric_create_ingestion_destination
appfabric_create_ingestion_destination <- function(appBundleIdentifier, ingestionIdentifier, processingConfiguration, destinationConfiguration, clientToken = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateIngestionDestination",
    http_method = "POST",
    http_path = "/appbundles/{appBundleIdentifier}/ingestions/{ingestionIdentifier}/ingestiondestinations",
    paginator = list()
  )
  input <- .appfabric$create_ingestion_destination_input(appBundleIdentifier = appBundleIdentifier, ingestionIdentifier = ingestionIdentifier, processingConfiguration = processingConfiguration, destinationConfiguration = destinationConfiguration, clientToken = clientToken, tags = tags)
  output <- .appfabric$create_ingestion_destination_output()
  config <- get_config()
  svc <- .appfabric$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appfabric$operations$create_ingestion_destination <- appfabric_create_ingestion_destination

#' Deletes an app authorization
#'
#' @description
#' Deletes an app authorization. You must delete the associated ingestion before you can delete an app authorization.
#'
#' See [https://www.paws-r-sdk.com/docs/appfabric_delete_app_authorization/](https://www.paws-r-sdk.com/docs/appfabric_delete_app_authorization/) for full documentation.
#'
#' @param appBundleIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the app bundle to use for the request.
#' @param appAuthorizationIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the app authorization to use for the request.
#'
#' @keywords internal
#'
#' @rdname appfabric_delete_app_authorization
appfabric_delete_app_authorization <- function(appBundleIdentifier, appAuthorizationIdentifier) {
  op <- new_operation(
    name = "DeleteAppAuthorization",
    http_method = "DELETE",
    http_path = "/appbundles/{appBundleIdentifier}/appauthorizations/{appAuthorizationIdentifier}",
    paginator = list()
  )
  input <- .appfabric$delete_app_authorization_input(appBundleIdentifier = appBundleIdentifier, appAuthorizationIdentifier = appAuthorizationIdentifier)
  output <- .appfabric$delete_app_authorization_output()
  config <- get_config()
  svc <- .appfabric$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appfabric$operations$delete_app_authorization <- appfabric_delete_app_authorization

#' Deletes an app bundle
#'
#' @description
#' Deletes an app bundle. You must delete all associated app authorizations before you can delete an app bundle.
#'
#' See [https://www.paws-r-sdk.com/docs/appfabric_delete_app_bundle/](https://www.paws-r-sdk.com/docs/appfabric_delete_app_bundle/) for full documentation.
#'
#' @param appBundleIdentifier &#91;required&#93; The ID or Amazon Resource Name (ARN) of the app bundle that needs to be
#' deleted.
#'
#' @keywords internal
#'
#' @rdname appfabric_delete_app_bundle
appfabric_delete_app_bundle <- function(appBundleIdentifier) {
  op <- new_operation(
    name = "DeleteAppBundle",
    http_method = "DELETE",
    http_path = "/appbundles/{appBundleIdentifier}",
    paginator = list()
  )
  input <- .appfabric$delete_app_bundle_input(appBundleIdentifier = appBundleIdentifier)
  output <- .appfabric$delete_app_bundle_output()
  config <- get_config()
  svc <- .appfabric$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appfabric$operations$delete_app_bundle <- appfabric_delete_app_bundle

#' Deletes an ingestion
#'
#' @description
#' Deletes an ingestion. You must stop (disable) the ingestion and you must delete all associated ingestion destinations before you can delete an app ingestion.
#'
#' See [https://www.paws-r-sdk.com/docs/appfabric_delete_ingestion/](https://www.paws-r-sdk.com/docs/appfabric_delete_ingestion/) for full documentation.
#'
#' @param appBundleIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the app bundle to use for the request.
#' @param ingestionIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the ingestion to use for the request.
#'
#' @keywords internal
#'
#' @rdname appfabric_delete_ingestion
appfabric_delete_ingestion <- function(appBundleIdentifier, ingestionIdentifier) {
  op <- new_operation(
    name = "DeleteIngestion",
    http_method = "DELETE",
    http_path = "/appbundles/{appBundleIdentifier}/ingestions/{ingestionIdentifier}",
    paginator = list()
  )
  input <- .appfabric$delete_ingestion_input(appBundleIdentifier = appBundleIdentifier, ingestionIdentifier = ingestionIdentifier)
  output <- .appfabric$delete_ingestion_output()
  config <- get_config()
  svc <- .appfabric$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appfabric$operations$delete_ingestion <- appfabric_delete_ingestion

#' Deletes an ingestion destination
#'
#' @description
#' Deletes an ingestion destination.
#'
#' See [https://www.paws-r-sdk.com/docs/appfabric_delete_ingestion_destination/](https://www.paws-r-sdk.com/docs/appfabric_delete_ingestion_destination/) for full documentation.
#'
#' @param appBundleIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the app bundle to use for the request.
#' @param ingestionIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the ingestion to use for the request.
#' @param ingestionDestinationIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the ingestion destination to use for the request.
#'
#' @keywords internal
#'
#' @rdname appfabric_delete_ingestion_destination
appfabric_delete_ingestion_destination <- function(appBundleIdentifier, ingestionIdentifier, ingestionDestinationIdentifier) {
  op <- new_operation(
    name = "DeleteIngestionDestination",
    http_method = "DELETE",
    http_path = "/appbundles/{appBundleIdentifier}/ingestions/{ingestionIdentifier}/ingestiondestinations/{ingestionDestinationIdentifier}",
    paginator = list()
  )
  input <- .appfabric$delete_ingestion_destination_input(appBundleIdentifier = appBundleIdentifier, ingestionIdentifier = ingestionIdentifier, ingestionDestinationIdentifier = ingestionDestinationIdentifier)
  output <- .appfabric$delete_ingestion_destination_output()
  config <- get_config()
  svc <- .appfabric$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appfabric$operations$delete_ingestion_destination <- appfabric_delete_ingestion_destination

#' Returns information about an app authorization
#'
#' @description
#' Returns information about an app authorization.
#'
#' See [https://www.paws-r-sdk.com/docs/appfabric_get_app_authorization/](https://www.paws-r-sdk.com/docs/appfabric_get_app_authorization/) for full documentation.
#'
#' @param appBundleIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the app bundle to use for the request.
#' @param appAuthorizationIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the app authorization to use for the request.
#'
#' @keywords internal
#'
#' @rdname appfabric_get_app_authorization
appfabric_get_app_authorization <- function(appBundleIdentifier, appAuthorizationIdentifier) {
  op <- new_operation(
    name = "GetAppAuthorization",
    http_method = "GET",
    http_path = "/appbundles/{appBundleIdentifier}/appauthorizations/{appAuthorizationIdentifier}",
    paginator = list()
  )
  input <- .appfabric$get_app_authorization_input(appBundleIdentifier = appBundleIdentifier, appAuthorizationIdentifier = appAuthorizationIdentifier)
  output <- .appfabric$get_app_authorization_output()
  config <- get_config()
  svc <- .appfabric$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appfabric$operations$get_app_authorization <- appfabric_get_app_authorization

#' Returns information about an app bundle
#'
#' @description
#' Returns information about an app bundle.
#'
#' See [https://www.paws-r-sdk.com/docs/appfabric_get_app_bundle/](https://www.paws-r-sdk.com/docs/appfabric_get_app_bundle/) for full documentation.
#'
#' @param appBundleIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the app bundle to use for the request.
#'
#' @keywords internal
#'
#' @rdname appfabric_get_app_bundle
appfabric_get_app_bundle <- function(appBundleIdentifier) {
  op <- new_operation(
    name = "GetAppBundle",
    http_method = "GET",
    http_path = "/appbundles/{appBundleIdentifier}",
    paginator = list()
  )
  input <- .appfabric$get_app_bundle_input(appBundleIdentifier = appBundleIdentifier)
  output <- .appfabric$get_app_bundle_output()
  config <- get_config()
  svc <- .appfabric$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appfabric$operations$get_app_bundle <- appfabric_get_app_bundle

#' Returns information about an ingestion
#'
#' @description
#' Returns information about an ingestion.
#'
#' See [https://www.paws-r-sdk.com/docs/appfabric_get_ingestion/](https://www.paws-r-sdk.com/docs/appfabric_get_ingestion/) for full documentation.
#'
#' @param appBundleIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the app bundle to use for the request.
#' @param ingestionIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the ingestion to use for the request.
#'
#' @keywords internal
#'
#' @rdname appfabric_get_ingestion
appfabric_get_ingestion <- function(appBundleIdentifier, ingestionIdentifier) {
  op <- new_operation(
    name = "GetIngestion",
    http_method = "GET",
    http_path = "/appbundles/{appBundleIdentifier}/ingestions/{ingestionIdentifier}",
    paginator = list()
  )
  input <- .appfabric$get_ingestion_input(appBundleIdentifier = appBundleIdentifier, ingestionIdentifier = ingestionIdentifier)
  output <- .appfabric$get_ingestion_output()
  config <- get_config()
  svc <- .appfabric$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appfabric$operations$get_ingestion <- appfabric_get_ingestion

#' Returns information about an ingestion destination
#'
#' @description
#' Returns information about an ingestion destination.
#'
#' See [https://www.paws-r-sdk.com/docs/appfabric_get_ingestion_destination/](https://www.paws-r-sdk.com/docs/appfabric_get_ingestion_destination/) for full documentation.
#'
#' @param appBundleIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the app bundle to use for the request.
#' @param ingestionIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the ingestion to use for the request.
#' @param ingestionDestinationIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the ingestion destination to use for the request.
#'
#' @keywords internal
#'
#' @rdname appfabric_get_ingestion_destination
appfabric_get_ingestion_destination <- function(appBundleIdentifier, ingestionIdentifier, ingestionDestinationIdentifier) {
  op <- new_operation(
    name = "GetIngestionDestination",
    http_method = "GET",
    http_path = "/appbundles/{appBundleIdentifier}/ingestions/{ingestionIdentifier}/ingestiondestinations/{ingestionDestinationIdentifier}",
    paginator = list()
  )
  input <- .appfabric$get_ingestion_destination_input(appBundleIdentifier = appBundleIdentifier, ingestionIdentifier = ingestionIdentifier, ingestionDestinationIdentifier = ingestionDestinationIdentifier)
  output <- .appfabric$get_ingestion_destination_output()
  config <- get_config()
  svc <- .appfabric$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appfabric$operations$get_ingestion_destination <- appfabric_get_ingestion_destination

#' Returns a list of all app authorizations configured for an app bundle
#'
#' @description
#' Returns a list of all app authorizations configured for an app bundle.
#'
#' See [https://www.paws-r-sdk.com/docs/appfabric_list_app_authorizations/](https://www.paws-r-sdk.com/docs/appfabric_list_app_authorizations/) for full documentation.
#'
#' @param appBundleIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the app bundle to use for the request.
#' @param maxResults The maximum number of results that are returned per call. You can use
#' `nextToken` to obtain further pages of results.
#' 
#' This is only an upper limit. The actual number of results returned per
#' call might be fewer than the specified maximum.
#' @param nextToken If `nextToken` is returned, there are more results available. The value
#' of `nextToken` is a unique pagination token for each page. Make the call
#' again using the returned token to retrieve the next page. Keep all other
#' arguments unchanged. Each pagination token expires after 24 hours. Using
#' an expired pagination token will return an *HTTP 400 InvalidToken
#' error*.
#'
#' @keywords internal
#'
#' @rdname appfabric_list_app_authorizations
appfabric_list_app_authorizations <- function(appBundleIdentifier, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAppAuthorizations",
    http_method = "GET",
    http_path = "/appbundles/{appBundleIdentifier}/appauthorizations",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "appAuthorizationSummaryList")
  )
  input <- .appfabric$list_app_authorizations_input(appBundleIdentifier = appBundleIdentifier, maxResults = maxResults, nextToken = nextToken)
  output <- .appfabric$list_app_authorizations_output()
  config <- get_config()
  svc <- .appfabric$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appfabric$operations$list_app_authorizations <- appfabric_list_app_authorizations

#' Returns a list of app bundles
#'
#' @description
#' Returns a list of app bundles.
#'
#' See [https://www.paws-r-sdk.com/docs/appfabric_list_app_bundles/](https://www.paws-r-sdk.com/docs/appfabric_list_app_bundles/) for full documentation.
#'
#' @param maxResults The maximum number of results that are returned per call. You can use
#' `nextToken` to obtain further pages of results.
#' 
#' This is only an upper limit. The actual number of results returned per
#' call might be fewer than the specified maximum.
#' @param nextToken If `nextToken` is returned, there are more results available. The value
#' of `nextToken` is a unique pagination token for each page. Make the call
#' again using the returned token to retrieve the next page. Keep all other
#' arguments unchanged. Each pagination token expires after 24 hours. Using
#' an expired pagination token will return an *HTTP 400 InvalidToken
#' error*.
#'
#' @keywords internal
#'
#' @rdname appfabric_list_app_bundles
appfabric_list_app_bundles <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAppBundles",
    http_method = "GET",
    http_path = "/appbundles",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "appBundleSummaryList")
  )
  input <- .appfabric$list_app_bundles_input(maxResults = maxResults, nextToken = nextToken)
  output <- .appfabric$list_app_bundles_output()
  config <- get_config()
  svc <- .appfabric$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appfabric$operations$list_app_bundles <- appfabric_list_app_bundles

#' Returns a list of all ingestion destinations configured for an ingestion
#'
#' @description
#' Returns a list of all ingestion destinations configured for an ingestion.
#'
#' See [https://www.paws-r-sdk.com/docs/appfabric_list_ingestion_destinations/](https://www.paws-r-sdk.com/docs/appfabric_list_ingestion_destinations/) for full documentation.
#'
#' @param appBundleIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the app bundle to use for the request.
#' @param ingestionIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the ingestion to use for the request.
#' @param maxResults The maximum number of results that are returned per call. You can use
#' `nextToken` to obtain further pages of results.
#' 
#' This is only an upper limit. The actual number of results returned per
#' call might be fewer than the specified maximum.
#' @param nextToken If `nextToken` is returned, there are more results available. The value
#' of `nextToken` is a unique pagination token for each page. Make the call
#' again using the returned token to retrieve the next page. Keep all other
#' arguments unchanged. Each pagination token expires after 24 hours. Using
#' an expired pagination token will return an *HTTP 400 InvalidToken
#' error*.
#'
#' @keywords internal
#'
#' @rdname appfabric_list_ingestion_destinations
appfabric_list_ingestion_destinations <- function(appBundleIdentifier, ingestionIdentifier, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListIngestionDestinations",
    http_method = "GET",
    http_path = "/appbundles/{appBundleIdentifier}/ingestions/{ingestionIdentifier}/ingestiondestinations",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "ingestionDestinations")
  )
  input <- .appfabric$list_ingestion_destinations_input(appBundleIdentifier = appBundleIdentifier, ingestionIdentifier = ingestionIdentifier, maxResults = maxResults, nextToken = nextToken)
  output <- .appfabric$list_ingestion_destinations_output()
  config <- get_config()
  svc <- .appfabric$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appfabric$operations$list_ingestion_destinations <- appfabric_list_ingestion_destinations

#' Returns a list of all ingestions configured for an app bundle
#'
#' @description
#' Returns a list of all ingestions configured for an app bundle.
#'
#' See [https://www.paws-r-sdk.com/docs/appfabric_list_ingestions/](https://www.paws-r-sdk.com/docs/appfabric_list_ingestions/) for full documentation.
#'
#' @param appBundleIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the app bundle to use for the request.
#' @param maxResults The maximum number of results that are returned per call. You can use
#' `nextToken` to obtain further pages of results.
#' 
#' This is only an upper limit. The actual number of results returned per
#' call might be fewer than the specified maximum.
#' @param nextToken If `nextToken` is returned, there are more results available. The value
#' of `nextToken` is a unique pagination token for each page. Make the call
#' again using the returned token to retrieve the next page. Keep all other
#' arguments unchanged. Each pagination token expires after 24 hours. Using
#' an expired pagination token will return an *HTTP 400 InvalidToken
#' error*.
#'
#' @keywords internal
#'
#' @rdname appfabric_list_ingestions
appfabric_list_ingestions <- function(appBundleIdentifier, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListIngestions",
    http_method = "GET",
    http_path = "/appbundles/{appBundleIdentifier}/ingestions",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "ingestions")
  )
  input <- .appfabric$list_ingestions_input(appBundleIdentifier = appBundleIdentifier, maxResults = maxResults, nextToken = nextToken)
  output <- .appfabric$list_ingestions_output()
  config <- get_config()
  svc <- .appfabric$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appfabric$operations$list_ingestions <- appfabric_list_ingestions

#' Returns a list of tags for a resource
#'
#' @description
#' Returns a list of tags for a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/appfabric_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/appfabric_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource for which you want to
#' retrieve tags.
#'
#' @keywords internal
#'
#' @rdname appfabric_list_tags_for_resource
appfabric_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .appfabric$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .appfabric$list_tags_for_resource_output()
  config <- get_config()
  svc <- .appfabric$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appfabric$operations$list_tags_for_resource <- appfabric_list_tags_for_resource

#' Starts (enables) an ingestion, which collects data from an application
#'
#' @description
#' Starts (enables) an ingestion, which collects data from an application.
#'
#' See [https://www.paws-r-sdk.com/docs/appfabric_start_ingestion/](https://www.paws-r-sdk.com/docs/appfabric_start_ingestion/) for full documentation.
#'
#' @param ingestionIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the ingestion to use for the request.
#' @param appBundleIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the app bundle to use for the request.
#'
#' @keywords internal
#'
#' @rdname appfabric_start_ingestion
appfabric_start_ingestion <- function(ingestionIdentifier, appBundleIdentifier) {
  op <- new_operation(
    name = "StartIngestion",
    http_method = "POST",
    http_path = "/appbundles/{appBundleIdentifier}/ingestions/{ingestionIdentifier}/start",
    paginator = list()
  )
  input <- .appfabric$start_ingestion_input(ingestionIdentifier = ingestionIdentifier, appBundleIdentifier = appBundleIdentifier)
  output <- .appfabric$start_ingestion_output()
  config <- get_config()
  svc <- .appfabric$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appfabric$operations$start_ingestion <- appfabric_start_ingestion

#' Starts the tasks to search user access status for a specific email
#' address
#'
#' @description
#' Starts the tasks to search user access status for a specific email address.
#'
#' See [https://www.paws-r-sdk.com/docs/appfabric_start_user_access_tasks/](https://www.paws-r-sdk.com/docs/appfabric_start_user_access_tasks/) for full documentation.
#'
#' @param appBundleIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the app bundle to use for the request.
#' @param email &#91;required&#93; The email address of the target user.
#'
#' @keywords internal
#'
#' @rdname appfabric_start_user_access_tasks
appfabric_start_user_access_tasks <- function(appBundleIdentifier, email) {
  op <- new_operation(
    name = "StartUserAccessTasks",
    http_method = "POST",
    http_path = "/useraccess/start",
    paginator = list()
  )
  input <- .appfabric$start_user_access_tasks_input(appBundleIdentifier = appBundleIdentifier, email = email)
  output <- .appfabric$start_user_access_tasks_output()
  config <- get_config()
  svc <- .appfabric$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appfabric$operations$start_user_access_tasks <- appfabric_start_user_access_tasks

#' Stops (disables) an ingestion
#'
#' @description
#' Stops (disables) an ingestion.
#'
#' See [https://www.paws-r-sdk.com/docs/appfabric_stop_ingestion/](https://www.paws-r-sdk.com/docs/appfabric_stop_ingestion/) for full documentation.
#'
#' @param ingestionIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the ingestion to use for the request.
#' @param appBundleIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the app bundle to use for the request.
#'
#' @keywords internal
#'
#' @rdname appfabric_stop_ingestion
appfabric_stop_ingestion <- function(ingestionIdentifier, appBundleIdentifier) {
  op <- new_operation(
    name = "StopIngestion",
    http_method = "POST",
    http_path = "/appbundles/{appBundleIdentifier}/ingestions/{ingestionIdentifier}/stop",
    paginator = list()
  )
  input <- .appfabric$stop_ingestion_input(ingestionIdentifier = ingestionIdentifier, appBundleIdentifier = appBundleIdentifier)
  output <- .appfabric$stop_ingestion_output()
  config <- get_config()
  svc <- .appfabric$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appfabric$operations$stop_ingestion <- appfabric_stop_ingestion

#' Assigns one or more tags (key-value pairs) to the specified resource
#'
#' @description
#' Assigns one or more tags (key-value pairs) to the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/appfabric_tag_resource/](https://www.paws-r-sdk.com/docs/appfabric_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to tag.
#' @param tags &#91;required&#93; A map of the key-value pairs of the tag or tags to assign to the
#' resource.
#'
#' @keywords internal
#'
#' @rdname appfabric_tag_resource
appfabric_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .appfabric$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .appfabric$tag_resource_output()
  config <- get_config()
  svc <- .appfabric$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appfabric$operations$tag_resource <- appfabric_tag_resource

#' Removes a tag or tags from a resource
#'
#' @description
#' Removes a tag or tags from a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/appfabric_untag_resource/](https://www.paws-r-sdk.com/docs/appfabric_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to untag.
#' @param tagKeys &#91;required&#93; The keys of the key-value pairs for the tag or tags you want to remove
#' from the specified resource.
#'
#' @keywords internal
#'
#' @rdname appfabric_untag_resource
appfabric_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .appfabric$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .appfabric$untag_resource_output()
  config <- get_config()
  svc <- .appfabric$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appfabric$operations$untag_resource <- appfabric_untag_resource

#' Updates an app authorization within an app bundle, which allows
#' AppFabric to connect to an application
#'
#' @description
#' Updates an app authorization within an app bundle, which allows AppFabric to connect to an application.
#'
#' See [https://www.paws-r-sdk.com/docs/appfabric_update_app_authorization/](https://www.paws-r-sdk.com/docs/appfabric_update_app_authorization/) for full documentation.
#'
#' @param appBundleIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the app bundle to use for the request.
#' @param appAuthorizationIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the app authorization to use for the request.
#' @param credential Contains credentials for the application, such as an API key or OAuth2
#' client ID and secret.
#' 
#' Specify credentials that match the authorization type of the app
#' authorization to update. For example, if the authorization type of the
#' app authorization is OAuth2 (`oauth2`), then you should provide only the
#' OAuth2 credentials.
#' @param tenant Contains information about an application tenant, such as the
#' application display name and identifier.
#'
#' @keywords internal
#'
#' @rdname appfabric_update_app_authorization
appfabric_update_app_authorization <- function(appBundleIdentifier, appAuthorizationIdentifier, credential = NULL, tenant = NULL) {
  op <- new_operation(
    name = "UpdateAppAuthorization",
    http_method = "PATCH",
    http_path = "/appbundles/{appBundleIdentifier}/appauthorizations/{appAuthorizationIdentifier}",
    paginator = list()
  )
  input <- .appfabric$update_app_authorization_input(appBundleIdentifier = appBundleIdentifier, appAuthorizationIdentifier = appAuthorizationIdentifier, credential = credential, tenant = tenant)
  output <- .appfabric$update_app_authorization_output()
  config <- get_config()
  svc <- .appfabric$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appfabric$operations$update_app_authorization <- appfabric_update_app_authorization

#' Updates an ingestion destination, which specifies how an application's
#' ingested data is processed by Amazon Web Services AppFabric and where
#' it's delivered
#'
#' @description
#' Updates an ingestion destination, which specifies how an application's ingested data is processed by Amazon Web Services AppFabric and where it's delivered.
#'
#' See [https://www.paws-r-sdk.com/docs/appfabric_update_ingestion_destination/](https://www.paws-r-sdk.com/docs/appfabric_update_ingestion_destination/) for full documentation.
#'
#' @param appBundleIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the app bundle to use for the request.
#' @param ingestionIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the ingestion to use for the request.
#' @param ingestionDestinationIdentifier &#91;required&#93; The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
#' the ingestion destination to use for the request.
#' @param destinationConfiguration &#91;required&#93; Contains information about the destination of ingested data.
#'
#' @keywords internal
#'
#' @rdname appfabric_update_ingestion_destination
appfabric_update_ingestion_destination <- function(appBundleIdentifier, ingestionIdentifier, ingestionDestinationIdentifier, destinationConfiguration) {
  op <- new_operation(
    name = "UpdateIngestionDestination",
    http_method = "PATCH",
    http_path = "/appbundles/{appBundleIdentifier}/ingestions/{ingestionIdentifier}/ingestiondestinations/{ingestionDestinationIdentifier}",
    paginator = list()
  )
  input <- .appfabric$update_ingestion_destination_input(appBundleIdentifier = appBundleIdentifier, ingestionIdentifier = ingestionIdentifier, ingestionDestinationIdentifier = ingestionDestinationIdentifier, destinationConfiguration = destinationConfiguration)
  output <- .appfabric$update_ingestion_destination_output()
  config <- get_config()
  svc <- .appfabric$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appfabric$operations$update_ingestion_destination <- appfabric_update_ingestion_destination
