# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS Cloud Map
#'
#' @description
#' Cloud Map
#' 
#' With Cloud Map, you can configure public DNS, private DNS, or HTTP
#' namespaces that your microservice applications run in. When an instance
#' becomes available, you can call the Cloud Map API to register the
#' instance with Cloud Map. For public or private DNS namespaces, Cloud Map
#' automatically creates DNS records and an optional health check. Clients
#' that submit public or private DNS queries, or HTTP requests, for the
#' service receive an answer that contains up to eight healthy records.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e., `http://s3.amazonaws.com/BUCKET/KEY`.}
#' }
#'
#' @section Service syntax:
#' ```
#' svc <- servicediscovery(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- servicediscovery()
#' # This example creates an HTTP namespace.
#' svc$create_http_namespace(
#'   CreatorRequestId = "example-creator-request-id-0001",
#'   Description = "Example.com AWS Cloud Map HTTP Namespace",
#'   Name = "example-http.com"
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=servicediscovery_create_http_namespace]{create_http_namespace} \tab Creates an HTTP namespace\cr
#'  \link[=servicediscovery_create_private_dns_namespace]{create_private_dns_namespace} \tab Creates a private namespace based on DNS, which is visible only inside a specified Amazon VPC\cr
#'  \link[=servicediscovery_create_public_dns_namespace]{create_public_dns_namespace} \tab Creates a public namespace based on DNS, which is visible on the internet\cr
#'  \link[=servicediscovery_create_service]{create_service} \tab Creates a service\cr
#'  \link[=servicediscovery_delete_namespace]{delete_namespace} \tab Deletes a namespace from the current account\cr
#'  \link[=servicediscovery_delete_service]{delete_service} \tab Deletes a specified service\cr
#'  \link[=servicediscovery_deregister_instance]{deregister_instance} \tab Deletes the Amazon Route 53 DNS records and health check, if any, that Cloud Map created for the specified instance\cr
#'  \link[=servicediscovery_discover_instances]{discover_instances} \tab Discovers registered instances for a specified namespace and service\cr
#'  \link[=servicediscovery_get_instance]{get_instance} \tab Gets information about a specified instance\cr
#'  \link[=servicediscovery_get_instances_health_status]{get_instances_health_status} \tab Gets the current health status (Healthy, Unhealthy, or Unknown) of one or more instances that are associated with a specified service\cr
#'  \link[=servicediscovery_get_namespace]{get_namespace} \tab Gets information about a namespace\cr
#'  \link[=servicediscovery_get_operation]{get_operation} \tab Gets information about any operation that returns an operation ID in the response, such as a CreateService request\cr
#'  \link[=servicediscovery_get_service]{get_service} \tab Gets the settings for a specified service\cr
#'  \link[=servicediscovery_list_instances]{list_instances} \tab Lists summary information about the instances that you registered by using a specified service\cr
#'  \link[=servicediscovery_list_namespaces]{list_namespaces} \tab Lists summary information about the namespaces that were created by the current Amazon Web Services account\cr
#'  \link[=servicediscovery_list_operations]{list_operations} \tab Lists operations that match the criteria that you specify\cr
#'  \link[=servicediscovery_list_services]{list_services} \tab Lists summary information for all the services that are associated with one or more specified namespaces\cr
#'  \link[=servicediscovery_list_tags_for_resource]{list_tags_for_resource} \tab Lists tags for the specified resource\cr
#'  \link[=servicediscovery_register_instance]{register_instance} \tab Creates or updates one or more records and, optionally, creates a health check based on the settings in a specified service\cr
#'  \link[=servicediscovery_tag_resource]{tag_resource} \tab Adds one or more tags to the specified resource\cr
#'  \link[=servicediscovery_untag_resource]{untag_resource} \tab Removes one or more tags from the specified resource\cr
#'  \link[=servicediscovery_update_http_namespace]{update_http_namespace} \tab Updates an HTTP namespace\cr
#'  \link[=servicediscovery_update_instance_custom_health_status]{update_instance_custom_health_status} \tab Submits a request to change the health status of a custom health check to healthy or unhealthy\cr
#'  \link[=servicediscovery_update_private_dns_namespace]{update_private_dns_namespace} \tab Updates a private DNS namespace\cr
#'  \link[=servicediscovery_update_public_dns_namespace]{update_public_dns_namespace} \tab Updates a public DNS namespace\cr
#'  \link[=servicediscovery_update_service]{update_service} \tab Submits a request to perform the following operations:
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname servicediscovery
#' @export
servicediscovery <- function(config = list()) {
  svc <- .servicediscovery$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.servicediscovery <- list()

.servicediscovery$operations <- list()

.servicediscovery$metadata <- list(
  service_name = "servicediscovery",
  endpoints = list("*" = list(endpoint = "servicediscovery.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "servicediscovery.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "servicediscovery.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "servicediscovery.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "ServiceDiscovery",
  api_version = "2017-03-14",
  signing_name = "servicediscovery",
  json_version = "1.1",
  target_prefix = "Route53AutoNaming_v20170314"
)

.servicediscovery$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.servicediscovery$metadata, handlers, config)
}
