% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_associate_resolver_query_log_config}
\alias{route53resolver_associate_resolver_query_log_config}
\title{Associates an Amazon VPC with a specified query logging configuration}
\usage{
route53resolver_associate_resolver_query_log_config(
  ResolverQueryLogConfigId,
  ResourceId
)
}
\arguments{
\item{ResolverQueryLogConfigId}{[required] The ID of the query logging configuration that you want to associate a
VPC with.}

\item{ResourceId}{[required] The ID of an Amazon VPC that you want this query logging configuration
to log queries for.

The VPCs and the query logging configuration must be in the same Region.}
}
\description{
Associates an Amazon VPC with a specified query logging configuration. Route 53 Resolver logs DNS queries that originate in all of the Amazon VPCs that are associated with a specified query logging configuration. To associate more than one VPC with a configuration, submit one \code{\link[=route53resolver_associate_resolver_query_log_config]{associate_resolver_query_log_config}} request for each VPC.

See \url{https://paws-r.github.io/docs/route53resolver/associate_resolver_query_log_config.html} for full documentation.
}
\keyword{internal}
