% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_list_hosted_zones_by_vpc}
\alias{route53_list_hosted_zones_by_vpc}
\title{Lists all the private hosted zones that a specified VPC is associated
with, regardless of which Amazon Web Services account or Amazon Web
Services service owns the hosted zones}
\usage{
route53_list_hosted_zones_by_vpc(
  VPCId,
  VPCRegion,
  MaxItems = NULL,
  NextToken = NULL
)
}
\arguments{
\item{VPCId}{[required] The ID of the Amazon VPC that you want to list hosted zones for.}

\item{VPCRegion}{[required] For the Amazon VPC that you specified for \code{VPCId}, the Amazon Web
Services Region that you created the VPC in.}

\item{MaxItems}{(Optional) The maximum number of hosted zones that you want Amazon Route
53 to return. If the specified VPC is associated with more than
\code{MaxItems} hosted zones, the response includes a \code{NextToken} element.
\code{NextToken} contains an encrypted token that identifies the first hosted
zone that Route 53 will return if you submit another request.}

\item{NextToken}{If the previous response included a \code{NextToken} element, the specified
VPC is associated with more hosted zones. To get more hosted zones,
submit another
\code{\link[=route53_list_hosted_zones_by_vpc]{list_hosted_zones_by_vpc}} request.

For the value of \code{NextToken}, specify the value of \code{NextToken} from the
previous response.

If the previous response didn't include a \code{NextToken} element, there are
no more hosted zones to get.}
}
\description{
Lists all the private hosted zones that a specified VPC is associated with, regardless of which Amazon Web Services account or Amazon Web Services service owns the hosted zones. The \code{HostedZoneOwner} structure in the response contains one of the following values:

See \url{https://paws-r.github.io/docs/route53/list_hosted_zones_by_vpc.html} for full documentation.
}
\keyword{internal}
