% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmesh_operations.R
\name{appmesh_update_virtual_gateway}
\alias{appmesh_update_virtual_gateway}
\title{Updates an existing virtual gateway in a specified service mesh}
\usage{
appmesh_update_virtual_gateway(clientToken, meshName, meshOwner, spec,
  virtualGatewayName)
}
\arguments{
\item{clientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. Up to 36 letters, numbers, hyphens, and
underscores are allowed.}

\item{meshName}{[required] The name of the service mesh that the virtual gateway resides in.}

\item{meshOwner}{The AWS IAM account ID of the service mesh owner. If the account ID is
not your own, then it\'s the ID of the account that shared the mesh with
your account. For more information about mesh sharing, see \href{https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html}{Working with shared meshes}.}

\item{spec}{[required] The new virtual gateway specification to apply. This overwrites the
existing data.}

\item{virtualGatewayName}{[required] The name of the virtual gateway to update.}
}
\description{
Updates an existing virtual gateway in a specified service mesh.
}
\section{Request syntax}{
\preformatted{svc$update_virtual_gateway(
  clientToken = "string",
  meshName = "string",
  meshOwner = "string",
  spec = list(
    backendDefaults = list(
      clientPolicy = list(
        tls = list(
          enforce = TRUE|FALSE,
          ports = list(
            123
          ),
          validation = list(
            trust = list(
              acm = list(
                certificateAuthorityArns = list(
                  "string"
                )
              ),
              file = list(
                certificateChain = "string"
              )
            )
          )
        )
      )
    ),
    listeners = list(
      list(
        healthCheck = list(
          healthyThreshold = 123,
          intervalMillis = 123,
          path = "string",
          port = 123,
          protocol = "grpc"|"http"|"http2",
          timeoutMillis = 123,
          unhealthyThreshold = 123
        ),
        portMapping = list(
          port = 123,
          protocol = "grpc"|"http"|"http2"
        ),
        tls = list(
          certificate = list(
            acm = list(
              certificateArn = "string"
            ),
            file = list(
              certificateChain = "string",
              privateKey = "string"
            )
          ),
          mode = "DISABLED"|"PERMISSIVE"|"STRICT"
        )
      )
    ),
    logging = list(
      accessLog = list(
        file = list(
          path = "string"
        )
      )
    )
  ),
  virtualGatewayName = "string"
)
}
}

\keyword{internal}
