% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmesh_operations.R
\name{appmesh_update_virtual_service}
\alias{appmesh_update_virtual_service}
\title{Updates an existing virtual service in a specified service mesh}
\usage{
appmesh_update_virtual_service(clientToken, meshName, spec,
  virtualServiceName)
}
\arguments{
\item{clientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. Up to 36 letters, numbers, hyphens, and
underscores are allowed.}

\item{meshName}{[required] The name of the service mesh that the virtual service resides in.}

\item{spec}{[required] The new virtual service specification to apply. This overwrites the
existing data.}

\item{virtualServiceName}{[required] The name of the virtual service to update.}
}
\description{
Updates an existing virtual service in a specified service mesh.
}
\section{Request syntax}{
\preformatted{svc$update_virtual_service(
  clientToken = "string",
  meshName = "string",
  spec = list(
    provider = list(
      virtualNode = list(
        virtualNodeName = "string"
      ),
      virtualRouter = list(
        virtualRouterName = "string"
      )
    )
  ),
  virtualServiceName = "string"
)
}
}

\keyword{internal}
