% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_delete_listener}
\alias{elbv2_delete_listener}
\title{Deletes the specified listener}
\usage{
elbv2_delete_listener(ListenerArn)
}
\arguments{
\item{ListenerArn}{[required] The Amazon Resource Name (ARN) of the listener.}
}
\value{
An empty list.
}
\description{
Deletes the specified listener.

Alternatively, your listener is deleted when you delete the load
balancer to which it is attached.
}
\section{Request syntax}{
\preformatted{svc$delete_listener(
  ListenerArn = "string"
)
}
}

\examples{
\dontrun{
# This example deletes the specified listener.
svc$delete_listener(
  ListenerArn = "arn:aws:elasticloadbalancing:ua-west-2:123456789012:listen..."
)
}

}
\keyword{internal}
