% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directconnect_operations.R
\name{directconnect_start_bgp_failover_test}
\alias{directconnect_start_bgp_failover_test}
\title{Starts the virtual interface failover test that verifies your
configuration meets your resiliency requirements by placing the BGP
peering session in the DOWN state}
\usage{
directconnect_start_bgp_failover_test(virtualInterfaceId, bgpPeers,
  testDurationInMinutes)
}
\arguments{
\item{virtualInterfaceId}{[required] The ID of the virtual interface you want to test.}

\item{bgpPeers}{The BGP peers to place in the DOWN state.}

\item{testDurationInMinutes}{The time in minutes that the virtual interface failover test will last.

Maximum value: 180 minutes (3 hours).

Default: 180 minutes (3 hours).}
}
\value{
A list with the following syntax:\preformatted{list(
  virtualInterfaceTest = list(
    testId = "string",
    virtualInterfaceId = "string",
    bgpPeers = list(
      "string"
    ),
    status = "string",
    ownerAccount = "string",
    testDurationInMinutes = 123,
    startTime = as.POSIXct(
      "2015-01-01"
    ),
    endTime = as.POSIXct(
      "2015-01-01"
    )
  )
)
}
}
\description{
Starts the virtual interface failover test that verifies your
configuration meets your resiliency requirements by placing the BGP
peering session in the DOWN state. You can then send traffic to verify
that there are no outages.

You can run the test on public, private, transit, and hosted virtual
interfaces.

You can use
\code{\link[=directconnect_list_virtual_interface_test_history]{list_virtual_interface_test_history}}
to view the virtual interface test history.

If you need to stop the test before the test interval completes, use
\code{\link[=directconnect_stop_bgp_failover_test]{stop_bgp_failover_test}}.
}
\section{Request syntax}{
\preformatted{svc$start_bgp_failover_test(
  virtualInterfaceId = "string",
  bgpPeers = list(
    "string"
  ),
  testDurationInMinutes = 123
)
}
}

\keyword{internal}
