# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include apigatewaymanagementapi_service.R
NULL

#' Delete the connection with the provided id
#'
#' @description
#' Delete the connection with the provided id.
#'
#' @usage
#' apigatewaymanagementapi_delete_connection(ConnectionId)
#'
#' @param ConnectionId &#91;required&#93; 
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_connection(
#'   ConnectionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewaymanagementapi_delete_connection
apigatewaymanagementapi_delete_connection <- function(ConnectionId) {
  op <- new_operation(
    name = "DeleteConnection",
    http_method = "DELETE",
    http_path = "/@connections/{connectionId}",
    paginator = list()
  )
  input <- .apigatewaymanagementapi$delete_connection_input(ConnectionId = ConnectionId)
  output <- .apigatewaymanagementapi$delete_connection_output()
  config <- get_config()
  svc <- .apigatewaymanagementapi$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewaymanagementapi$operations$delete_connection <- apigatewaymanagementapi_delete_connection

#' Get information about the connection with the provided id
#'
#' @description
#' Get information about the connection with the provided id.
#'
#' @usage
#' apigatewaymanagementapi_get_connection(ConnectionId)
#'
#' @param ConnectionId &#91;required&#93; 
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ConnectedAt = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Identity = list(
#'     SourceIp = "string",
#'     UserAgent = "string"
#'   ),
#'   LastActiveAt = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_connection(
#'   ConnectionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewaymanagementapi_get_connection
apigatewaymanagementapi_get_connection <- function(ConnectionId) {
  op <- new_operation(
    name = "GetConnection",
    http_method = "GET",
    http_path = "/@connections/{connectionId}",
    paginator = list()
  )
  input <- .apigatewaymanagementapi$get_connection_input(ConnectionId = ConnectionId)
  output <- .apigatewaymanagementapi$get_connection_output()
  config <- get_config()
  svc <- .apigatewaymanagementapi$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewaymanagementapi$operations$get_connection <- apigatewaymanagementapi_get_connection

#' Sends the provided data to the specified connection
#'
#' @description
#' Sends the provided data to the specified connection.
#'
#' @usage
#' apigatewaymanagementapi_post_to_connection(Data, ConnectionId)
#'
#' @param Data &#91;required&#93; The data to be sent to the client specified by its connection id.
#' @param ConnectionId &#91;required&#93; The identifier of the connection that a specific client is using.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$post_to_connection(
#'   Data = raw,
#'   ConnectionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewaymanagementapi_post_to_connection
apigatewaymanagementapi_post_to_connection <- function(Data, ConnectionId) {
  op <- new_operation(
    name = "PostToConnection",
    http_method = "POST",
    http_path = "/@connections/{connectionId}",
    paginator = list()
  )
  input <- .apigatewaymanagementapi$post_to_connection_input(Data = Data, ConnectionId = ConnectionId)
  output <- .apigatewaymanagementapi$post_to_connection_output()
  config <- get_config()
  svc <- .apigatewaymanagementapi$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewaymanagementapi$operations$post_to_connection <- apigatewaymanagementapi_post_to_connection
