% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directconnect_operations.R
\name{directconnect_describe_direct_connect_gateway_association_proposals}
\alias{directconnect_describe_direct_connect_gateway_association_proposals}
\title{Describes one or more association proposals for connection between a
virtual private gateway or transit gateway and a Direct Connect gateway}
\usage{
directconnect_describe_direct_connect_gateway_association_proposals(
  directConnectGatewayId, proposalId, associatedGatewayId, maxResults,
  nextToken)
}
\arguments{
\item{directConnectGatewayId}{The ID of the Direct Connect gateway.}

\item{proposalId}{The ID of the proposal.}

\item{associatedGatewayId}{The ID of the associated gateway.}

\item{maxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.

If \code{MaxResults} is given a value larger than 100, only 100 results are
returned.}

\item{nextToken}{The token for the next page of results.}
}
\value{
A list with the following syntax:\preformatted{list(
  directConnectGatewayAssociationProposals = list(
    list(
      proposalId = "string",
      directConnectGatewayId = "string",
      directConnectGatewayOwnerAccount = "string",
      proposalState = "requested"|"accepted"|"deleted",
      associatedGateway = list(
        id = "string",
        type = "virtualPrivateGateway"|"transitGateway",
        ownerAccount = "string",
        region = "string"
      ),
      existingAllowedPrefixesToDirectConnectGateway = list(
        list(
          cidr = "string"
        )
      ),
      requestedAllowedPrefixesToDirectConnectGateway = list(
        list(
          cidr = "string"
        )
      )
    )
  ),
  nextToken = "string"
)
}
}
\description{
Describes one or more association proposals for connection between a
virtual private gateway or transit gateway and a Direct Connect gateway.
}
\section{Request syntax}{
\preformatted{svc$describe_direct_connect_gateway_association_proposals(
  directConnectGatewayId = "string",
  proposalId = "string",
  associatedGatewayId = "string",
  maxResults = 123,
  nextToken = "string"
)
}
}

\keyword{internal}
