% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigateway_operations.R
\name{apigateway_get_stage}
\alias{apigateway_get_stage}
\title{Gets information about a Stage resource}
\usage{
apigateway_get_stage(restApiId, stageName)
}
\arguments{
\item{restApiId}{[required] [Required] The string identifier of the associated RestApi.}

\item{stageName}{[required] [Required] The name of the Stage resource to get information about.}
}
\value{
A list with the following syntax:\preformatted{list(
  deploymentId = "string",
  clientCertificateId = "string",
  stageName = "string",
  description = "string",
  cacheClusterEnabled = TRUE|FALSE,
  cacheClusterSize = "0.5"|"1.6"|"6.1"|"13.5"|"28.4"|"58.2"|"118"|"237",
  cacheClusterStatus = "CREATE_IN_PROGRESS"|"AVAILABLE"|"DELETE_IN_PROGRESS"|"NOT_AVAILABLE"|"FLUSH_IN_PROGRESS",
  methodSettings = list(
    list(
      metricsEnabled = TRUE|FALSE,
      loggingLevel = "string",
      dataTraceEnabled = TRUE|FALSE,
      throttlingBurstLimit = 123,
      throttlingRateLimit = 123.0,
      cachingEnabled = TRUE|FALSE,
      cacheTtlInSeconds = 123,
      cacheDataEncrypted = TRUE|FALSE,
      requireAuthorizationForCacheControl = TRUE|FALSE,
      unauthorizedCacheControlHeaderStrategy = "FAIL_WITH_403"|"SUCCEED_WITH_RESPONSE_HEADER"|"SUCCEED_WITHOUT_RESPONSE_HEADER"
    )
  ),
  variables = list(
    "string"
  ),
  documentationVersion = "string",
  accessLogSettings = list(
    format = "string",
    destinationArn = "string"
  ),
  canarySettings = list(
    percentTraffic = 123.0,
    deploymentId = "string",
    stageVariableOverrides = list(
      "string"
    ),
    useStageCache = TRUE|FALSE
  ),
  tracingEnabled = TRUE|FALSE,
  webAclArn = "string",
  tags = list(
    "string"
  ),
  createdDate = as.POSIXct(
    "2015-01-01"
  ),
  lastUpdatedDate = as.POSIXct(
    "2015-01-01"
  )
)
}
}
\description{
Gets information about a Stage resource.
}
\section{Request syntax}{
\preformatted{svc$get_stage(
  restApiId = "string",
  stageName = "string"
)
}
}

\keyword{internal}
