% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_describe_target_group_attributes}
\alias{elbv2_describe_target_group_attributes}
\title{Describes the attributes for the specified target group}
\usage{
elbv2_describe_target_group_attributes(TargetGroupArn)
}
\arguments{
\item{TargetGroupArn}{[required] The Amazon Resource Name (ARN) of the target group.}
}
\description{
Describes the attributes for the specified target group.

For more information, see the following:
\itemize{
\item \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#target-group-attributes}{Target group attributes}
in the \emph{Application Load Balancers Guide}
\item \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#target-group-attributes}{Target group attributes}
in the \emph{Network Load Balancers Guide}
\item \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html#target-group-attributes}{Target group attributes}
in the \emph{Gateway Load Balancers Guide}
}
}
\section{Request syntax}{
\preformatted{svc$describe_target_group_attributes(
  TargetGroupArn = "string"
)
}
}

\examples{
\dontrun{
# This example describes the attributes of the specified target group.
svc$describe_target_group_attributes(
  TargetGroupArn = "arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targe..."
)
}

}
\keyword{internal}
