% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_describe_listeners}
\alias{elbv2_describe_listeners}
\title{Describes the specified listeners or the listeners for the specified
Application Load Balancer, Network Load Balancer, or Gateway Load
Balancer}
\usage{
elbv2_describe_listeners(LoadBalancerArn, ListenerArns, Marker,
  PageSize)
}
\arguments{
\item{LoadBalancerArn}{The Amazon Resource Name (ARN) of the load balancer.}

\item{ListenerArns}{The Amazon Resource Names (ARN) of the listeners.}

\item{Marker}{The marker for the next set of results. (You received this marker from a
previous call.)}

\item{PageSize}{The maximum number of results to return with this call.}
}
\description{
Describes the specified listeners or the listeners for the specified
Application Load Balancer, Network Load Balancer, or Gateway Load
Balancer. You must specify either a load balancer or one or more
listeners.
}
\section{Request syntax}{
\preformatted{svc$describe_listeners(
  LoadBalancerArn = "string",
  ListenerArns = list(
    "string"
  ),
  Marker = "string",
  PageSize = 123
)
}
}

\examples{
\dontrun{
# This example describes the specified listener.
svc$describe_listeners(
  ListenerArns = list(
    "arn:aws:elasticloadbalancing:us-west-2:123456789012:listener/app/my-load-balancer/50dc6..."
  )
)
}

}
\keyword{internal}
