% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directconnect_operations.R
\name{directconnect_create_direct_connect_gateway_association}
\alias{directconnect_create_direct_connect_gateway_association}
\title{Creates an association between a Direct Connect gateway and a virtual
private gateway}
\usage{
directconnect_create_direct_connect_gateway_association(
  directConnectGatewayId, gatewayId,
  addAllowedPrefixesToDirectConnectGateway, virtualGatewayId)
}
\arguments{
\item{directConnectGatewayId}{[required] The ID of the Direct Connect gateway.}

\item{gatewayId}{The ID of the virtual private gateway.}

\item{addAllowedPrefixesToDirectConnectGateway}{The Amazon VPC prefixes to advertise to the Direct Connect gateway}

\item{virtualGatewayId}{The ID of the virtual private gateway.}
}
\description{
Creates an association between a Direct Connect gateway and a virtual
private gateway. The virtual private gateway must be attached to a VPC
and must not be associated with another Direct Connect gateway.
}
\section{Request syntax}{
\preformatted{svc$create_direct_connect_gateway_association(
  directConnectGatewayId = "string",
  gatewayId = "string",
  addAllowedPrefixesToDirectConnectGateway = list(
    list(
      cidr = "string"
    )
  ),
  virtualGatewayId = "string"
)
}
}

\keyword{internal}
