% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controltower_operations.R
\name{controltower_enable_baseline}
\alias{controltower_enable_baseline}
\title{Enable (apply) a Baseline to a Target}
\usage{
controltower_enable_baseline(
  baselineIdentifier,
  baselineVersion,
  parameters = NULL,
  tags = NULL,
  targetIdentifier
)
}
\arguments{
\item{baselineIdentifier}{[required] The ARN of the baseline to be enabled.}

\item{baselineVersion}{[required] The specific version to be enabled of the specified baseline.}

\item{parameters}{A list of \code{key-value} objects that specify enablement parameters, where
\code{key} is a string and \code{value} is a document of any type.}

\item{tags}{Tags associated with input to
\code{\link[=controltower_enable_baseline]{enable_baseline}}.}

\item{targetIdentifier}{[required] The ARN of the target on which the baseline will be enabled. Only OUs
are supported as targets.}
}
\description{
Enable (apply) a \code{Baseline} to a Target. This API starts an asynchronous operation to deploy resources specified by the \code{Baseline} to the specified Target. For usage examples, see \href{https://docs.aws.amazon.com/controltower/latest/userguide/baseline-api-examples.html}{\emph{the Amazon Web Services Control Tower User Guide}} .

See \url{https://www.paws-r-sdk.com/docs/controltower_enable_baseline/} for full documentation.
}
\keyword{internal}
