% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_create_document}
\alias{ssm_create_document}
\title{Creates a Amazon Web Services Systems Manager (SSM document)}
\usage{
ssm_create_document(
  Content,
  Requires = NULL,
  Attachments = NULL,
  Name,
  DisplayName = NULL,
  VersionName = NULL,
  DocumentType = NULL,
  DocumentFormat = NULL,
  TargetType = NULL,
  Tags = NULL
)
}
\arguments{
\item{Content}{[required] The content for the new SSM document in JSON or YAML format. The content
of the document must not exceed 64KB. This quota also includes the
content specified for input parameters at runtime. We recommend storing
the contents for your new document in an external JSON or YAML file and
referencing the file in a command.

For examples, see the following topics in the \emph{Amazon Web Services
Systems Manager User Guide}.
\itemize{
\item \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/documents-using.html#create-ssm-console}{Create an SSM document (console)}
\item \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/documents-using.html#create-ssm-document-cli}{Create an SSM document (command line)}
\item \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/documents-using.html#create-ssm-document-api}{Create an SSM document (API)}
}}

\item{Requires}{A list of SSM documents required by a document. This parameter is used
exclusively by AppConfig. When a user creates an AppConfig configuration
in an SSM document, the user must also specify a required document for
validation purposes. In this case, an \code{ApplicationConfiguration}
document requires an \code{ApplicationConfigurationSchema} document for
validation purposes. For more information, see \href{https://docs.aws.amazon.com/appconfig/latest/userguide/what-is-appconfig.html}{What is AppConfig?}
in the \emph{AppConfig User Guide}.}

\item{Attachments}{A list of key-value pairs that describe attachments to a version of a
document.}

\item{Name}{[required] A name for the SSM document.

You can't use the following strings as document name prefixes. These are
reserved by Amazon Web Services for use as document name prefixes:
\itemize{
\item \code{aws}
\item \code{amazon}
\item \code{amzn}
\item \code{AWSEC2}
\item \code{AWSConfigRemediation}
\item \code{AWSSupport}
}}

\item{DisplayName}{An optional field where you can specify a friendly name for the SSM
document. This value can differ for each version of the document. You
can update this value at a later time using the
\code{\link[=ssm_update_document]{update_document}} operation.}

\item{VersionName}{An optional field specifying the version of the artifact you are
creating with the document. For example, \code{Release12.1}. This value is
unique across all versions of a document, and can't be changed.}

\item{DocumentType}{The type of document to create.

The \code{DeploymentStrategy} document type is an internal-use-only document
type reserved for AppConfig.}

\item{DocumentFormat}{Specify the document format for the request. The document format can be
JSON, YAML, or TEXT. JSON is the default format.}

\item{TargetType}{Specify a target type to define the kinds of resources the document can
run on. For example, to run a document on EC2 instances, specify the
following value: \verb{/AWS::EC2::Instance}. If you specify a value of '/'
the document can run on all types of resources. If you don't specify a
value, the document can't run on any resources. For a list of valid
resource types, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html}{Amazon Web Services resource and property types reference}
in the \emph{CloudFormation User Guide}.}

\item{Tags}{Optional metadata that you assign to a resource. Tags enable you to
categorize a resource in different ways, such as by purpose, owner, or
environment. For example, you might want to tag an SSM document to
identify the types of targets or the environment where it will run. In
this case, you could specify the following key-value pairs:
\itemize{
\item \verb{Key=OS,Value=Windows}
\item \verb{Key=Environment,Value=Production}
}

To add tags to an existing SSM document, use the
\code{\link[=ssm_add_tags_to_resource]{add_tags_to_resource}} operation.}
}
\description{
Creates a Amazon Web Services Systems Manager (SSM document). An SSM document defines the actions that Systems Manager performs on your managed nodes. For more information about SSM documents, including information about supported schemas, features, and syntax, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/documents.html}{Amazon Web Services Systems Manager Documents} in the \emph{Amazon Web Services Systems Manager User Guide}.

See \url{https://www.paws-r-sdk.com/docs/ssm_create_document/} for full documentation.
}
\keyword{internal}
