# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon Prometheus Service
#'
#' @description
#' Amazon Managed Service for Prometheus is a serverless,
#' Prometheus-compatible monitoring service for container metrics that
#' makes it easier to securely monitor container environments at scale.
#' With Amazon Managed Service for Prometheus, you can use the same
#' open-source Prometheus data model and query language that you use today
#' to monitor the performance of your containerized workloads, and also
#' enjoy improved scalability, availability, and security without having to
#' manage the underlying infrastructure.
#' 
#' For more information about Amazon Managed Service for Prometheus, see
#' the [Amazon Managed Service for
#' Prometheus](https://docs.aws.amazon.com/prometheus/latest/userguide/what-is-Amazon-Managed-Service-Prometheus.html)
#' User Guide.
#' 
#' Amazon Managed Service for Prometheus includes two APIs.
#' 
#' -   Use the Amazon Web Services API described in this guide to manage
#'     Amazon Managed Service for Prometheus resources, such as workspaces,
#'     rule groups, and alert managers.
#' 
#' -   Use the [Prometheus-compatible
#'     API](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-Prometheus-Compatible-Apis)
#'     to work within your Prometheus workspace.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- prometheusservice(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- prometheusservice()
#' svc$create_alert_manager_definition(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=prometheusservice_create_alert_manager_definition]{create_alert_manager_definition} \tab The CreateAlertManagerDefinition operation creates the alert manager definition in a workspace\cr
#'  \link[=prometheusservice_create_logging_configuration]{create_logging_configuration} \tab The CreateLoggingConfiguration operation creates a logging configuration for the workspace\cr
#'  \link[=prometheusservice_create_rule_groups_namespace]{create_rule_groups_namespace} \tab The CreateRuleGroupsNamespace operation creates a rule groups namespace within a workspace\cr
#'  \link[=prometheusservice_create_scraper]{create_scraper} \tab The CreateScraper operation creates a scraper to collect metrics\cr
#'  \link[=prometheusservice_create_workspace]{create_workspace} \tab Creates a Prometheus workspace\cr
#'  \link[=prometheusservice_delete_alert_manager_definition]{delete_alert_manager_definition} \tab Deletes the alert manager definition from a workspace\cr
#'  \link[=prometheusservice_delete_logging_configuration]{delete_logging_configuration} \tab Deletes the logging configuration for a workspace\cr
#'  \link[=prometheusservice_delete_rule_groups_namespace]{delete_rule_groups_namespace} \tab Deletes one rule groups namespace and its associated rule groups definition\cr
#'  \link[=prometheusservice_delete_scraper]{delete_scraper} \tab The DeleteScraper operation deletes one scraper, and stops any metrics collection that the scraper performs\cr
#'  \link[=prometheusservice_delete_workspace]{delete_workspace} \tab Deletes an existing workspace\cr
#'  \link[=prometheusservice_describe_alert_manager_definition]{describe_alert_manager_definition} \tab Retrieves the full information about the alert manager definition for a workspace\cr
#'  \link[=prometheusservice_describe_logging_configuration]{describe_logging_configuration} \tab Returns complete information about the current logging configuration of the workspace\cr
#'  \link[=prometheusservice_describe_rule_groups_namespace]{describe_rule_groups_namespace} \tab Returns complete information about one rule groups namespace\cr
#'  \link[=prometheusservice_describe_scraper]{describe_scraper} \tab The DescribeScraper operation displays information about an existing scraper\cr
#'  \link[=prometheusservice_describe_workspace]{describe_workspace} \tab Returns information about an existing workspace\cr
#'  \link[=prometheusservice_get_default_scraper_configuration]{get_default_scraper_configuration} \tab The GetDefaultScraperConfiguration operation returns the default scraper configuration used when Amazon EKS creates a scraper for you\cr
#'  \link[=prometheusservice_list_rule_groups_namespaces]{list_rule_groups_namespaces} \tab Returns a list of rule groups namespaces in a workspace\cr
#'  \link[=prometheusservice_list_scrapers]{list_scrapers} \tab The ListScrapers operation lists all of the scrapers in your account\cr
#'  \link[=prometheusservice_list_tags_for_resource]{list_tags_for_resource} \tab The ListTagsForResource operation returns the tags that are associated with an Amazon Managed Service for Prometheus resource\cr
#'  \link[=prometheusservice_list_workspaces]{list_workspaces} \tab Lists all of the Amazon Managed Service for Prometheus workspaces in your account\cr
#'  \link[=prometheusservice_put_alert_manager_definition]{put_alert_manager_definition} \tab Updates an existing alert manager definition in a workspace\cr
#'  \link[=prometheusservice_put_rule_groups_namespace]{put_rule_groups_namespace} \tab Updates an existing rule groups namespace within a workspace\cr
#'  \link[=prometheusservice_tag_resource]{tag_resource} \tab The TagResource operation associates tags with an Amazon Managed Service for Prometheus resource\cr
#'  \link[=prometheusservice_untag_resource]{untag_resource} \tab Removes the specified tags from an Amazon Managed Service for Prometheus resource\cr
#'  \link[=prometheusservice_update_logging_configuration]{update_logging_configuration} \tab Updates the log group ARN or the workspace ID of the current logging configuration\cr
#'  \link[=prometheusservice_update_workspace_alias]{update_workspace_alias} \tab Updates the alias of an existing workspace
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname prometheusservice
#' @export
prometheusservice <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .prometheusservice$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.prometheusservice <- list()

.prometheusservice$operations <- list()

.prometheusservice$metadata <- list(
  service_name = "prometheusservice",
  endpoints = list("*" = list(endpoint = "aps.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "aps.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "aps.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "aps.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "aps.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "aps.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "amp",
  api_version = "2020-08-01",
  signing_name = "aps",
  json_version = "1.1",
  target_prefix = ""
)

.prometheusservice$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.prometheusservice$metadata, handlers, config)
}
