% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controltower_operations.R
\name{controltower_list_enabled_controls}
\alias{controltower_list_enabled_controls}
\title{Lists the controls enabled by Amazon Web Services Control Tower on the
specified organizational unit and the accounts it contains}
\usage{
controltower_list_enabled_controls(
  maxResults = NULL,
  nextToken = NULL,
  targetIdentifier
)
}
\arguments{
\item{maxResults}{How many results to return per API call.}

\item{nextToken}{The token to continue the list from a previous API call with the same
parameters.}

\item{targetIdentifier}{[required] The ARN of the organizational unit. For information on how to find the
\code{targetIdentifier}, see \href{https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html}{the overview page}.}
}
\description{
Lists the controls enabled by Amazon Web Services Control Tower on the specified organizational unit and the accounts it contains. For usage examples, see \href{https://docs.aws.amazon.com/controltower/latest/userguide/control-api-examples-short.html}{\emph{the Amazon Web Services Control Tower User Guide}} .

See \url{https://www.paws-r-sdk.com/docs/controltower_list_enabled_controls/} for full documentation.
}
\keyword{internal}
