% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_operations.R
\name{support_describe_communications}
\alias{support_describe_communications}
\title{Returns communications and attachments for one or more support cases}
\usage{
support_describe_communications(
  caseId,
  beforeTime = NULL,
  afterTime = NULL,
  nextToken = NULL,
  maxResults = NULL
)
}
\arguments{
\item{caseId}{[required] The support case ID requested or returned in the call. The case ID is an
alphanumeric string formatted as shown in this example:
case-\emph{12345678910-2013-c4c1d2bf33c5cf47}}

\item{beforeTime}{The end date for a filtered date search on support case communications.
Case communications are available for 12 months after creation.}

\item{afterTime}{The start date for a filtered date search on support case
communications. Case communications are available for 12 months after
creation.}

\item{nextToken}{A resumption point for pagination.}

\item{maxResults}{The maximum number of results to return before paginating.}
}
\description{
Returns communications and attachments for one or more support cases. Use the \code{afterTime} and \code{beforeTime} parameters to filter by date. You can use the \code{caseId} parameter to restrict the results to a specific case.

See \url{https://paws-r.github.io/docs/support/describe_communications.html} for full documentation.
}
\keyword{internal}
