% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworkscm_operations.R
\name{opsworkscm_start_maintenance}
\alias{opsworkscm_start_maintenance}
\title{Manually starts server maintenance}
\usage{
opsworkscm_start_maintenance(ServerName, EngineAttributes = NULL)
}
\arguments{
\item{ServerName}{[required] The name of the server on which to run maintenance.}

\item{EngineAttributes}{Engine attributes that are specific to the server on which you want to
run maintenance.

\strong{Attributes accepted in a StartMaintenance request for Chef}
\itemize{
\item \code{CHEF_MAJOR_UPGRADE}: If a Chef Automate server is eligible for
upgrade to Chef Automate 2, add this engine attribute to a
\code{\link[=opsworkscm_start_maintenance]{start_maintenance}} request and set
the value to \code{true} to upgrade the server to Chef Automate 2. For
more information, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/opscm-a2upgrade.html}{Upgrade an AWS OpsWorks for Chef Automate Server to Chef Automate 2}.
}}
}
\description{
Manually starts server maintenance. This command can be useful if an earlier maintenance attempt failed, and the underlying cause of maintenance failure has been resolved. The server is in an \code{UNDER_MAINTENANCE} state while maintenance is in progress.

See \url{https://paws-r.github.io/docs/opsworkscm/start_maintenance.html} for full documentation.
}
\keyword{internal}
