% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_create_organization}
\alias{organizations_create_organization}
\title{Creates an AWS organization}
\usage{
organizations_create_organization(FeatureSet)
}
\arguments{
\item{FeatureSet}{Specifies the feature set supported by the new organization. Each
feature set supports different levels of functionality.
\itemize{
\item \code{CONSOLIDATED_BILLING}: All member accounts have their bills
consolidated to and paid by the master account. For more
information, see \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-cb-only}{Consolidated billing}
in the \emph{AWS Organizations User Guide.}

The consolidated billing feature subset isn\'t available for
organizations in the AWS GovCloud (US) Region.
\item \code{ALL}: In addition to all the features that consolidated billing
feature set supports, the master account can also apply any policy
type to any member account in the organization. For more
information, see \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-all}{All features}
in the \emph{AWS Organizations User Guide.}
}}
}
\description{
Creates an AWS organization. The account whose user is calling the
\code{CreateOrganization} operation automatically becomes the \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/orgs_getting-started_concepts.html#account}{master account}
of the new organization.
}
\details{
This operation must be called using credentials from the account that is
to become the new organization\'s master account. The principal must
also have the relevant IAM permissions.

By default (or if you set the \code{FeatureSet} parameter to \code{ALL}), the new
organization is created with all features enabled. In addition, service
control policies are automatically enabled in the root. If you instead
create the organization supporting only the consolidated billing
features, no policy types are enabled by default, and you can\'t use
organization policies.
}
\section{Request syntax}{
\preformatted{svc$create_organization(
  FeatureSet = "ALL"|"CONSOLIDATED_BILLING"
)
}
}

\examples{
# Bill wants to create an organization using credentials from account
# 111111111111. The following example shows that the account becomes the
# master account in the new organization. Because he does not specify a
# feature set, the new organization defaults to all features enabled and
# service control policies enabled on the root:
# 
# 
\donttest{svc$create_organization()}

# In the following example, Bill creates an organization using credentials
# from account 111111111111, and configures the organization to support
# only the consolidated billing feature set:
# 
# 
\donttest{svc$create_organization(
  FeatureSet = "CONSOLIDATED_BILLING"
)}

}
\keyword{internal}
