% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_list_stack_set_operations}
\alias{cloudformation_list_stack_set_operations}
\title{Returns summary information about operations performed on a stack set}
\usage{
cloudformation_list_stack_set_operations(StackSetName, NextToken,
  MaxResults)
}
\arguments{
\item{StackSetName}{[required] The name or unique ID of the stack set that you want to get operation
summaries for.}

\item{NextToken}{If the previous paginated request didn\'t return all of the remaining
results, the response object\'s \code{NextToken} parameter value is set to a
token. To retrieve the next set of results, call
\code{ListStackSetOperations} again and assign that token to the request
object\'s \code{NextToken} parameter. If there are no remaining results, the
previous response object\'s \code{NextToken} parameter is set to \code{null}.}

\item{MaxResults}{The maximum number of results to be returned with a single call. If the
number of available results exceeds this maximum, the response includes
a \code{NextToken} value that you can assign to the \code{NextToken} request
parameter to get the next set of results.}
}
\description{
Returns summary information about operations performed on a stack set.
}
\section{Request syntax}{
\preformatted{svc$list_stack_set_operations(
  StackSetName = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
