% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applicationinsights_operations.R
\name{applicationinsights_list_tags_for_resource}
\alias{applicationinsights_list_tags_for_resource}
\title{Retrieve a list of the tags (keys and values) that are associated with a
specified application}
\usage{
applicationinsights_list_tags_for_resource(ResourceARN)
}
\arguments{
\item{ResourceARN}{[required] The Amazon Resource Name (ARN) of the application that you want to
retrieve tag information for.}
}
\description{
Retrieve a list of the tags (keys and values) that are associated with a
specified application. A \emph{tag} is a label that you optionally define and
associate with an application. Each tag consists of a required \emph{tag key}
and an optional associated \emph{tag value}. A tag key is a general label
that acts as a category for more specific tag values. A tag value acts
as a descriptor within a tag key.
}
\section{Request syntax}{
\preformatted{svc$list_tags_for_resource(
  ResourceARN = "string"
)
}
}

\keyword{internal}
