% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_delete_policy}
\alias{organizations_delete_policy}
\title{Deletes the specified policy from your organization}
\usage{
organizations_delete_policy(PolicyId)
}
\arguments{
\item{PolicyId}{[required] The unique identifier (ID) of the policy that you want to delete. You
can get the ID from the ListPolicies or ListPoliciesForTarget
operations.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} for a policy ID
string requires "p-" followed by from 8 to 128 lowercase or uppercase
letters, digits, or the underscore character (\\_).}
}
\description{
Deletes the specified policy from your organization. Before you perform
this operation, you must first detach the policy from all organizational
units (OUs), roots, and accounts.

This operation can be called only from the organization's management
account.
}
\section{Request syntax}{
\preformatted{svc$delete_policy(
  PolicyId = "string"
)
}
}

\examples{
\dontrun{
# The following example shows how to delete a policy from an organization.
# The example assumes that you previously detached the policy from all
# entities:
# 
# 
svc$delete_policy(
  PolicyId = "p-examplepolicyid111"
)
}

}
\keyword{internal}
