% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_create_account}
\alias{organizations_create_account}
\title{Creates an AWS account that is automatically a member of the
organization whose credentials made the request}
\usage{
organizations_create_account(Email, AccountName, RoleName,
  IamUserAccessToBilling)
}
\arguments{
\item{Email}{[required] The email address of the owner to assign to the new member account. This
email address must not already be associated with another AWS account.
You must use a valid email address to complete account creation. You
can't access the root user of the account or remove an account that was
created with an invalid email address.}

\item{AccountName}{[required] The friendly name of the member account.}

\item{RoleName}{(Optional)

The name of an IAM role that AWS Organizations automatically
preconfigures in the new member account. This role trusts the master
account, allowing users in the master account to assume the role, as
permitted by the master account administrator. The role has
administrator permissions in the new member account.

If you don't specify this parameter, the role name defaults to
\code{OrganizationAccountAccessRole}.

For more information about how to use this role to access the member
account, see \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role}{Accessing and Administering the Member Accounts in Your Organization}
in the \emph{AWS Organizations User Guide}, and steps 2 and 3 in \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html}{Tutorial: Delegate Access Across AWS Accounts Using IAM Roles}
in the \emph{IAM User Guide}.

The \href{http://wikipedia.org/wiki/regex}{regex pattern} that is used to
validate this parameter is a string of characters that can consist of
uppercase letters, lowercase letters, digits with no spaces, and any of
the following characters: =,.@-}

\item{IamUserAccessToBilling}{If set to \code{ALLOW}, the new account enables IAM users to access account
billing information \emph{if} they have the required permissions. If set to
\code{DENY}, only the root user of the new account can access account billing
information. For more information, see \href{https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate}{Activating Access to the Billing and Cost Management Console}
in the \emph{AWS Billing and Cost Management User Guide}.

If you don't specify this parameter, the value defaults to \code{ALLOW}, and
IAM users and roles with the required permissions can access billing
information for the new account.}
}
\description{
Creates an AWS account that is automatically a member of the
organization whose credentials made the request. This is an asynchronous
request that AWS performs in the background. Because \code{CreateAccount}
operates asynchronously, it can return a successful completion message
even though account initialization might still be in progress. You might
need to wait a few minutes before you can successfully access the
account. To check the status of the request, do one of the following:
}
\details{
\itemize{
\item Use the \code{OperationId} response element from this operation to
provide as a parameter to the DescribeCreateAccountStatus operation.
\item Check the AWS CloudTrail log for the \code{CreateAccountResult} event.
For information on using AWS CloudTrail with Organizations, see
\href{http://docs.aws.amazon.com/organizations/latest/userguide/orgs_monitoring.html}{Monitoring the Activity in Your Organization}
in the \emph{AWS Organizations User Guide.}
}

The user who calls the API to create an account must have the
\code{organizations:CreateAccount} permission. If you enabled all features in
the organization, AWS Organizations will create the required
service-linked role named \code{AWSServiceRoleForOrganizations}. For more
information, see \href{http://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_integrate_services-using_slrs}{AWS Organizations and Service-Linked Roles}
in the \emph{AWS Organizations User Guide}.

AWS Organizations preconfigures the new member account with a role
(named \code{OrganizationAccountAccessRole} by default) that grants users in
the master account administrator permissions in the new member account.
Principals in the master account can assume the role. AWS Organizations
clones the company name and address information for the new account from
the organization's master account.

This operation can be called only from the organization's master
account.

For more information about creating accounts, see \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_create.html}{Creating an AWS Account in Your Organization}
in the \emph{AWS Organizations User Guide.}
\itemize{
\item When you create an account in an organization using the AWS
Organizations console, API, or CLI commands, the information
required for the account to operate as a standalone account, such as
a payment method and signing the end user license agreement (EULA)
is \emph{not} automatically collected. If you must remove an account from
your organization later, you can do so only after you provide the
missing information. Follow the steps at \href{http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info}{To leave an organization as a member account}
in the \emph{AWS Organizations User Guide}.
\item If you get an exception that indicates that you exceeded your
account limits for the organization, contact \href{https://console.aws.amazon.com/support/home#/}{AWS Support}.
\item If you get an exception that indicates that the operation failed
because your organization is still initializing, wait one hour and
then try again. If the error persists, contact \href{https://console.aws.amazon.com/support/home#/}{AWS Support}.
\item Using CreateAccount to create multiple temporary accounts isn't
recommended. You can only close an account from the Billing and Cost
Management Console, and you must be signed in as the root user. For
information on the requirements and process for closing an account,
see \href{http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_close.html}{Closing an AWS Account}
in the \emph{AWS Organizations User Guide}.
}

When you create a member account with this operation, you can choose
whether to create the account with the \strong{IAM User and Role Access to
Billing Information} switch enabled. If you enable it, IAM users and
roles that have appropriate permissions can view billing information for
the account. If you disable it, only the account root user can access
billing information. For information about how to disable this switch
for an account, see \href{https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html}{Granting Access to Your Billing Information and Tools}.
}
\section{Request syntax}{
\preformatted{svc$create_account(
  Email = "string",
  AccountName = "string",
  RoleName = "string",
  IamUserAccessToBilling = "ALLOW"|"DENY"
)
}
}

\examples{
# The owner of an organization creates a member account in the
# organization. The following example shows that when the organization
# owner creates the member account, the account is preconfigured with the
# name "Production Account" and an owner email address of
# susan@example.com.  An IAM role is automatically created using the
# default name because the roleName parameter is not used. AWS
# Organizations sends Susan a "Welcome to AWS" email:
# 
# 
\donttest{svc$create_account(
  AccountName = "Production Account",
  Email = "susan@example.com"
)}

}
\keyword{internal}
