% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrock_operations.R
\name{bedrock_list_model_invocation_jobs}
\alias{bedrock_list_model_invocation_jobs}
\title{Lists all batch inference jobs in the account}
\usage{
bedrock_list_model_invocation_jobs(
  submitTimeAfter = NULL,
  submitTimeBefore = NULL,
  statusEquals = NULL,
  nameContains = NULL,
  maxResults = NULL,
  nextToken = NULL,
  sortBy = NULL,
  sortOrder = NULL
)
}
\arguments{
\item{submitTimeAfter}{Specify a time to filter for batch inference jobs that were submitted
after the time you specify.}

\item{submitTimeBefore}{Specify a time to filter for batch inference jobs that were submitted
before the time you specify.}

\item{statusEquals}{Specify a status to filter for batch inference jobs whose statuses match
the string you specify.}

\item{nameContains}{Specify a string to filter for batch inference jobs whose names contain
the string.}

\item{maxResults}{The maximum number of results to return. If there are more results than
the number that you specify, a \code{nextToken} value is returned. Use the
\code{nextToken} in a request to return the next batch of results.}

\item{nextToken}{If there were more results than the value you specified in the
\code{maxResults} field in a previous
\code{\link[=bedrock_list_model_invocation_jobs]{list_model_invocation_jobs}}
request, the response would have returned a \code{nextToken} value. To see
the next batch of results, send the \code{nextToken} value in another
request.}

\item{sortBy}{An attribute by which to sort the results.}

\item{sortOrder}{Specifies whether to sort the results by ascending or descending order.}
}
\description{
Lists all batch inference jobs in the account. For more information, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-manage.html#batch-inference-view}{View details about a batch inference job}.

See \url{https://www.paws-r-sdk.com/docs/bedrock_list_model_invocation_jobs/} for full documentation.
}
\keyword{internal}
