# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include forecastservice_service.R
NULL

#' Creates an Amazon Forecast predictor
#'
#' @description
#' Creates an Amazon Forecast predictor.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_create_auto_predictor/](https://www.paws-r-sdk.com/docs/forecastservice_create_auto_predictor/) for full documentation.
#'
#' @param PredictorName &#91;required&#93; A unique name for the predictor
#' @param ForecastHorizon The number of time-steps that the model predicts. The forecast horizon
#' is also called the prediction length.
#' 
#' The maximum forecast horizon is the lesser of 500 time-steps or 1/4 of
#' the TARGET_TIME_SERIES dataset length. If you are retraining an existing
#' AutoPredictor, then the maximum forecast horizon is the lesser of 500
#' time-steps or 1/3 of the TARGET_TIME_SERIES dataset length.
#' 
#' If you are upgrading to an AutoPredictor or retraining an existing
#' AutoPredictor, you cannot update the forecast horizon parameter. You can
#' meet this requirement by providing longer time-series in the dataset.
#' @param ForecastTypes The forecast types used to train a predictor. You can specify up to five
#' forecast types. Forecast types can be quantiles from 0.01 to 0.99, by
#' increments of 0.01 or higher. You can also specify the mean forecast
#' with `mean`.
#' @param ForecastDimensions An array of dimension (field) names that specify how to group the
#' generated forecast.
#' 
#' For example, if you are generating forecasts for item sales across all
#' your stores, and your dataset contains a `store_id` field, you would
#' specify `store_id` as a dimension to group sales forecasts for each
#' store.
#' @param ForecastFrequency The frequency of predictions in a forecast.
#' 
#' Valid intervals are an integer followed by Y (Year), M (Month), W
#' (Week), D (Day), H (Hour), and min (Minute). For example, "1D" indicates
#' every day and "15min" indicates every 15 minutes. You cannot specify a
#' value that would overlap with the next larger frequency. That means, for
#' example, you cannot specify a frequency of 60 minutes, because that is
#' equivalent to 1 hour. The valid values for each frequency are the
#' following:
#' 
#' -   Minute - 1-59
#' 
#' -   Hour - 1-23
#' 
#' -   Day - 1-6
#' 
#' -   Week - 1-4
#' 
#' -   Month - 1-11
#' 
#' -   Year - 1
#' 
#' Thus, if you want every other week forecasts, specify "2W". Or, if you
#' want quarterly forecasts, you specify "3M".
#' 
#' The frequency must be greater than or equal to the TARGET_TIME_SERIES
#' dataset frequency.
#' 
#' When a RELATED_TIME_SERIES dataset is provided, the frequency must be
#' equal to the RELATED_TIME_SERIES dataset frequency.
#' @param DataConfig The data configuration for your dataset group and any additional
#' datasets.
#' @param EncryptionConfig 
#' @param ReferencePredictorArn The ARN of the predictor to retrain or upgrade. This parameter is only
#' used when retraining or upgrading a predictor. When creating a new
#' predictor, do not specify a value for this parameter.
#' 
#' When upgrading or retraining a predictor, only specify values for the
#' `ReferencePredictorArn` and `PredictorName`. The value for
#' `PredictorName` must be a unique predictor name.
#' @param OptimizationMetric The accuracy metric used to optimize the predictor.
#' @param ExplainPredictor Create an Explainability resource for the predictor.
#' @param Tags Optional metadata to help you categorize and organize your predictors.
#' Each tag consists of a key and an optional value, both of which you
#' define. Tag keys and values are case sensitive.
#' 
#' The following restrictions apply to tags:
#' 
#' -   For each resource, each tag key must be unique and each tag key must
#'     have one value.
#' 
#' -   Maximum number of tags per resource: 50.
#' 
#' -   Maximum key length: 128 Unicode characters in UTF-8.
#' 
#' -   Maximum value length: 256 Unicode characters in UTF-8.
#' 
#' -   Accepted characters: all letters and numbers, spaces representable
#'     in UTF-8, and + - = . _ : / @@. If your tagging schema is used
#'     across other services and resources, the character restrictions of
#'     those services also apply.
#' 
#' -   Key prefixes cannot include any upper or lowercase combination of
#'     `aws:` or `AWS:`. Values can have this prefix. If a tag value has
#'     `aws` as its prefix but the key does not, Forecast considers it to
#'     be a user tag and will count against the limit of 50 tags. Tags with
#'     only the key prefix of `aws` do not count against your tags per
#'     resource limit. You cannot edit or delete tag keys with this prefix.
#' @param MonitorConfig The configuration details for predictor monitoring. Provide a name for
#' the monitor resource to enable predictor monitoring.
#' 
#' Predictor monitoring allows you to see how your predictor's performance
#' changes over time. For more information, see [Predictor
#' Monitoring](https://docs.aws.amazon.com/forecast/latest/dg/predictor-monitoring.html).
#' @param TimeAlignmentBoundary The time boundary Forecast uses to align and aggregate any data that
#' doesn't align with your forecast frequency. Provide the unit of time and
#' the time boundary as a key value pair. For more information on
#' specifying a time boundary, see [Specifying a Time
#' Boundary](https://docs.aws.amazon.com/forecast/latest/dg/data-aggregation.html#specifying-time-boundary).
#' If you don't provide a time boundary, Forecast uses a set of [Default
#' Time
#' Boundaries](https://docs.aws.amazon.com/forecast/latest/dg/data-aggregation.html#default-time-boundaries).
#'
#' @keywords internal
#'
#' @rdname forecastservice_create_auto_predictor
forecastservice_create_auto_predictor <- function(PredictorName, ForecastHorizon = NULL, ForecastTypes = NULL, ForecastDimensions = NULL, ForecastFrequency = NULL, DataConfig = NULL, EncryptionConfig = NULL, ReferencePredictorArn = NULL, OptimizationMetric = NULL, ExplainPredictor = NULL, Tags = NULL, MonitorConfig = NULL, TimeAlignmentBoundary = NULL) {
  op <- new_operation(
    name = "CreateAutoPredictor",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$create_auto_predictor_input(PredictorName = PredictorName, ForecastHorizon = ForecastHorizon, ForecastTypes = ForecastTypes, ForecastDimensions = ForecastDimensions, ForecastFrequency = ForecastFrequency, DataConfig = DataConfig, EncryptionConfig = EncryptionConfig, ReferencePredictorArn = ReferencePredictorArn, OptimizationMetric = OptimizationMetric, ExplainPredictor = ExplainPredictor, Tags = Tags, MonitorConfig = MonitorConfig, TimeAlignmentBoundary = TimeAlignmentBoundary)
  output <- .forecastservice$create_auto_predictor_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$create_auto_predictor <- forecastservice_create_auto_predictor

#' Creates an Amazon Forecast dataset
#'
#' @description
#' Creates an Amazon Forecast dataset. The information about the dataset that you provide helps Forecast understand how to consume the data for model training. This includes the following:
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_create_dataset/](https://www.paws-r-sdk.com/docs/forecastservice_create_dataset/) for full documentation.
#'
#' @param DatasetName &#91;required&#93; A name for the dataset.
#' @param Domain &#91;required&#93; The domain associated with the dataset. When you add a dataset to a
#' dataset group, this value and the value specified for the `Domain`
#' parameter of the
#' [`create_dataset_group`][forecastservice_create_dataset_group] operation
#' must match.
#' 
#' The `Domain` and `DatasetType` that you choose determine the fields that
#' must be present in the training data that you import to the dataset. For
#' example, if you choose the `RETAIL` domain and `TARGET_TIME_SERIES` as
#' the `DatasetType`, Amazon Forecast requires `item_id`, `timestamp`, and
#' `demand` fields to be present in your data. For more information, see
#' [Importing
#' datasets](https://docs.aws.amazon.com/forecast/latest/dg/howitworks-datasets-groups.html).
#' @param DatasetType &#91;required&#93; The dataset type. Valid values depend on the chosen `Domain`.
#' @param DataFrequency The frequency of data collection. This parameter is required for
#' RELATED_TIME_SERIES datasets.
#' 
#' Valid intervals are an integer followed by Y (Year), M (Month), W
#' (Week), D (Day), H (Hour), and min (Minute). For example, "1D" indicates
#' every day and "15min" indicates every 15 minutes. You cannot specify a
#' value that would overlap with the next larger frequency. That means, for
#' example, you cannot specify a frequency of 60 minutes, because that is
#' equivalent to 1 hour. The valid values for each frequency are the
#' following:
#' 
#' -   Minute - 1-59
#' 
#' -   Hour - 1-23
#' 
#' -   Day - 1-6
#' 
#' -   Week - 1-4
#' 
#' -   Month - 1-11
#' 
#' -   Year - 1
#' 
#' Thus, if you want every other week forecasts, specify "2W". Or, if you
#' want quarterly forecasts, you specify "3M".
#' @param Schema &#91;required&#93; The schema for the dataset. The schema attributes and their order must
#' match the fields in your data. The dataset `Domain` and `DatasetType`
#' that you choose determine the minimum required fields in your training
#' data. For information about the required fields for a specific dataset
#' domain and type, see [Dataset Domains and Dataset
#' Types](https://docs.aws.amazon.com/forecast/latest/dg/howitworks-domains-ds-types.html).
#' @param EncryptionConfig An Key Management Service (KMS) key and the Identity and Access
#' Management (IAM) role that Amazon Forecast can assume to access the key.
#' @param Tags The optional metadata that you apply to the dataset to help you
#' categorize and organize them. Each tag consists of a key and an optional
#' value, both of which you define.
#' 
#' The following basic restrictions apply to tags:
#' 
#' -   Maximum number of tags per resource - 50.
#' 
#' -   For each resource, each tag key must be unique, and each tag key can
#'     have only one value.
#' 
#' -   Maximum key length - 128 Unicode characters in UTF-8.
#' 
#' -   Maximum value length - 256 Unicode characters in UTF-8.
#' 
#' -   If your tagging schema is used across multiple services and
#'     resources, remember that other services may have restrictions on
#'     allowed characters. Generally allowed characters are: letters,
#'     numbers, and spaces representable in UTF-8, and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Tag keys and values are case sensitive.
#' 
#' -   Do not use `aws:`, `AWS:`, or any upper or lowercase combination of
#'     such as a prefix for keys as it is reserved for Amazon Web Services
#'     use. You cannot edit or delete tag keys with this prefix. Values can
#'     have this prefix. If a tag value has `aws` as its prefix but the key
#'     does not, then Forecast considers it to be a user tag and will count
#'     against the limit of 50 tags. Tags with only the key prefix of `aws`
#'     do not count against your tags per resource limit.
#'
#' @keywords internal
#'
#' @rdname forecastservice_create_dataset
forecastservice_create_dataset <- function(DatasetName, Domain, DatasetType, DataFrequency = NULL, Schema, EncryptionConfig = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateDataset",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$create_dataset_input(DatasetName = DatasetName, Domain = Domain, DatasetType = DatasetType, DataFrequency = DataFrequency, Schema = Schema, EncryptionConfig = EncryptionConfig, Tags = Tags)
  output <- .forecastservice$create_dataset_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$create_dataset <- forecastservice_create_dataset

#' Creates a dataset group, which holds a collection of related datasets
#'
#' @description
#' Creates a dataset group, which holds a collection of related datasets. You can add datasets to the dataset group when you create the dataset group, or later by using the [`update_dataset_group`][forecastservice_update_dataset_group] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_create_dataset_group/](https://www.paws-r-sdk.com/docs/forecastservice_create_dataset_group/) for full documentation.
#'
#' @param DatasetGroupName &#91;required&#93; A name for the dataset group.
#' @param Domain &#91;required&#93; The domain associated with the dataset group. When you add a dataset to
#' a dataset group, this value and the value specified for the `Domain`
#' parameter of the [`create_dataset`][forecastservice_create_dataset]
#' operation must match.
#' 
#' The `Domain` and `DatasetType` that you choose determine the fields that
#' must be present in training data that you import to a dataset. For
#' example, if you choose the `RETAIL` domain and `TARGET_TIME_SERIES` as
#' the `DatasetType`, Amazon Forecast requires that `item_id`, `timestamp`,
#' and `demand` fields are present in your data. For more information, see
#' [Dataset
#' groups](https://docs.aws.amazon.com/forecast/latest/dg/howitworks-datasets-groups.html).
#' @param DatasetArns An array of Amazon Resource Names (ARNs) of the datasets that you want
#' to include in the dataset group.
#' @param Tags The optional metadata that you apply to the dataset group to help you
#' categorize and organize them. Each tag consists of a key and an optional
#' value, both of which you define.
#' 
#' The following basic restrictions apply to tags:
#' 
#' -   Maximum number of tags per resource - 50.
#' 
#' -   For each resource, each tag key must be unique, and each tag key can
#'     have only one value.
#' 
#' -   Maximum key length - 128 Unicode characters in UTF-8.
#' 
#' -   Maximum value length - 256 Unicode characters in UTF-8.
#' 
#' -   If your tagging schema is used across multiple services and
#'     resources, remember that other services may have restrictions on
#'     allowed characters. Generally allowed characters are: letters,
#'     numbers, and spaces representable in UTF-8, and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Tag keys and values are case sensitive.
#' 
#' -   Do not use `aws:`, `AWS:`, or any upper or lowercase combination of
#'     such as a prefix for keys as it is reserved for Amazon Web Services
#'     use. You cannot edit or delete tag keys with this prefix. Values can
#'     have this prefix. If a tag value has `aws` as its prefix but the key
#'     does not, then Forecast considers it to be a user tag and will count
#'     against the limit of 50 tags. Tags with only the key prefix of `aws`
#'     do not count against your tags per resource limit.
#'
#' @keywords internal
#'
#' @rdname forecastservice_create_dataset_group
forecastservice_create_dataset_group <- function(DatasetGroupName, Domain, DatasetArns = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateDatasetGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$create_dataset_group_input(DatasetGroupName = DatasetGroupName, Domain = Domain, DatasetArns = DatasetArns, Tags = Tags)
  output <- .forecastservice$create_dataset_group_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$create_dataset_group <- forecastservice_create_dataset_group

#' Imports your training data to an Amazon Forecast dataset
#'
#' @description
#' Imports your training data to an Amazon Forecast dataset. You provide the location of your training data in an Amazon Simple Storage Service (Amazon S3) bucket and the Amazon Resource Name (ARN) of the dataset that you want to import the data to.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_create_dataset_import_job/](https://www.paws-r-sdk.com/docs/forecastservice_create_dataset_import_job/) for full documentation.
#'
#' @param DatasetImportJobName &#91;required&#93; The name for the dataset import job. We recommend including the current
#' timestamp in the name, for example, `20190721DatasetImport`. This can
#' help you avoid getting a `ResourceAlreadyExistsException` exception.
#' @param DatasetArn &#91;required&#93; The Amazon Resource Name (ARN) of the Amazon Forecast dataset that you
#' want to import data to.
#' @param DataSource &#91;required&#93; The location of the training data to import and an Identity and Access
#' Management (IAM) role that Amazon Forecast can assume to access the
#' data. The training data must be stored in an Amazon S3 bucket.
#' 
#' If encryption is used, `DataSource` must include an Key Management
#' Service (KMS) key and the IAM role must allow Amazon Forecast permission
#' to access the key. The KMS key and IAM role must match those specified
#' in the `EncryptionConfig` parameter of the
#' [`create_dataset`][forecastservice_create_dataset] operation.
#' @param TimestampFormat The format of timestamps in the dataset. The format that you specify
#' depends on the `DataFrequency` specified when the dataset was created.
#' The following formats are supported
#' 
#' -   "yyyy-MM-dd"
#' 
#'     For the following data frequencies: Y, M, W, and D
#' 
#' -   "yyyy-MM-dd HH:mm:ss"
#' 
#'     For the following data frequencies: H, 30min, 15min, and 1min; and
#'     optionally, for: Y, M, W, and D
#' 
#' If the format isn't specified, Amazon Forecast expects the format to be
#' "yyyy-MM-dd HH:mm:ss".
#' @param TimeZone A single time zone for every item in your dataset. This option is ideal
#' for datasets with all timestamps within a single time zone, or if all
#' timestamps are normalized to a single time zone.
#' 
#' Refer to the [Joda-Time
#' API](https://joda-time.sourceforge.net/timezones.html) for a complete
#' list of valid time zone names.
#' @param UseGeolocationForTimeZone Automatically derive time zone information from the geolocation
#' attribute. This option is ideal for datasets that contain timestamps in
#' multiple time zones and those timestamps are expressed in local time.
#' @param GeolocationFormat The format of the geolocation attribute. The geolocation attribute can
#' be formatted in one of two ways:
#' 
#' -   `LAT_LONG` - the latitude and longitude in decimal format (Example:
#'     47.61_-122.33).
#' 
#' -   `CC_POSTALCODE` (US Only) - the country code (US), followed by the
#'     5-digit ZIP code (Example: US_98121).
#' @param Tags The optional metadata that you apply to the dataset import job to help
#' you categorize and organize them. Each tag consists of a key and an
#' optional value, both of which you define.
#' 
#' The following basic restrictions apply to tags:
#' 
#' -   Maximum number of tags per resource - 50.
#' 
#' -   For each resource, each tag key must be unique, and each tag key can
#'     have only one value.
#' 
#' -   Maximum key length - 128 Unicode characters in UTF-8.
#' 
#' -   Maximum value length - 256 Unicode characters in UTF-8.
#' 
#' -   If your tagging schema is used across multiple services and
#'     resources, remember that other services may have restrictions on
#'     allowed characters. Generally allowed characters are: letters,
#'     numbers, and spaces representable in UTF-8, and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Tag keys and values are case sensitive.
#' 
#' -   Do not use `aws:`, `AWS:`, or any upper or lowercase combination of
#'     such as a prefix for keys as it is reserved for Amazon Web Services
#'     use. You cannot edit or delete tag keys with this prefix. Values can
#'     have this prefix. If a tag value has `aws` as its prefix but the key
#'     does not, then Forecast considers it to be a user tag and will count
#'     against the limit of 50 tags. Tags with only the key prefix of `aws`
#'     do not count against your tags per resource limit.
#' @param Format The format of the imported data, CSV or PARQUET. The default value is
#' CSV.
#' @param ImportMode Specifies whether the dataset import job is a `FULL` or `INCREMENTAL`
#' import. A `FULL` dataset import replaces all of the existing data with
#' the newly imported data. An `INCREMENTAL` import appends the imported
#' data to the existing data.
#'
#' @keywords internal
#'
#' @rdname forecastservice_create_dataset_import_job
forecastservice_create_dataset_import_job <- function(DatasetImportJobName, DatasetArn, DataSource, TimestampFormat = NULL, TimeZone = NULL, UseGeolocationForTimeZone = NULL, GeolocationFormat = NULL, Tags = NULL, Format = NULL, ImportMode = NULL) {
  op <- new_operation(
    name = "CreateDatasetImportJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$create_dataset_import_job_input(DatasetImportJobName = DatasetImportJobName, DatasetArn = DatasetArn, DataSource = DataSource, TimestampFormat = TimestampFormat, TimeZone = TimeZone, UseGeolocationForTimeZone = UseGeolocationForTimeZone, GeolocationFormat = GeolocationFormat, Tags = Tags, Format = Format, ImportMode = ImportMode)
  output <- .forecastservice$create_dataset_import_job_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$create_dataset_import_job <- forecastservice_create_dataset_import_job

#' Explainability is only available for Forecasts and Predictors generated
#' from an AutoPredictor (CreateAutoPredictor)
#'
#' @description
#' Explainability is only available for Forecasts and Predictors generated from an AutoPredictor ([`create_auto_predictor`][forecastservice_create_auto_predictor])
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_create_explainability/](https://www.paws-r-sdk.com/docs/forecastservice_create_explainability/) for full documentation.
#'
#' @param ExplainabilityName &#91;required&#93; A unique name for the Explainability.
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the Predictor or Forecast used to
#' create the Explainability.
#' @param ExplainabilityConfig &#91;required&#93; The configuration settings that define the granularity of time series
#' and time points for the Explainability.
#' @param DataSource 
#' @param Schema 
#' @param EnableVisualization Create an Explainability visualization that is viewable within the
#' Amazon Web Services console.
#' @param StartDateTime If `TimePointGranularity` is set to `SPECIFIC`, define the first point
#' for the Explainability.
#' 
#' Use the following timestamp format: yyyy-MM-ddTHH:mm:ss (example:
#' 2015-01-01T20:00:00)
#' @param EndDateTime If `TimePointGranularity` is set to `SPECIFIC`, define the last time
#' point for the Explainability.
#' 
#' Use the following timestamp format: yyyy-MM-ddTHH:mm:ss (example:
#' 2015-01-01T20:00:00)
#' @param Tags Optional metadata to help you categorize and organize your resources.
#' Each tag consists of a key and an optional value, both of which you
#' define. Tag keys and values are case sensitive.
#' 
#' The following restrictions apply to tags:
#' 
#' -   For each resource, each tag key must be unique and each tag key must
#'     have one value.
#' 
#' -   Maximum number of tags per resource: 50.
#' 
#' -   Maximum key length: 128 Unicode characters in UTF-8.
#' 
#' -   Maximum value length: 256 Unicode characters in UTF-8.
#' 
#' -   Accepted characters: all letters and numbers, spaces representable
#'     in UTF-8, and + - = . _ : / @@. If your tagging schema is used
#'     across other services and resources, the character restrictions of
#'     those services also apply.
#' 
#' -   Key prefixes cannot include any upper or lowercase combination of
#'     `aws:` or `AWS:`. Values can have this prefix. If a tag value has
#'     `aws` as its prefix but the key does not, Forecast considers it to
#'     be a user tag and will count against the limit of 50 tags. Tags with
#'     only the key prefix of `aws` do not count against your tags per
#'     resource limit. You cannot edit or delete tag keys with this prefix.
#'
#' @keywords internal
#'
#' @rdname forecastservice_create_explainability
forecastservice_create_explainability <- function(ExplainabilityName, ResourceArn, ExplainabilityConfig, DataSource = NULL, Schema = NULL, EnableVisualization = NULL, StartDateTime = NULL, EndDateTime = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateExplainability",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$create_explainability_input(ExplainabilityName = ExplainabilityName, ResourceArn = ResourceArn, ExplainabilityConfig = ExplainabilityConfig, DataSource = DataSource, Schema = Schema, EnableVisualization = EnableVisualization, StartDateTime = StartDateTime, EndDateTime = EndDateTime, Tags = Tags)
  output <- .forecastservice$create_explainability_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$create_explainability <- forecastservice_create_explainability

#' Exports an Explainability resource created by the CreateExplainability
#' operation
#'
#' @description
#' Exports an Explainability resource created by the [`create_explainability`][forecastservice_create_explainability] operation. Exported files are exported to an Amazon Simple Storage Service (Amazon S3) bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_create_explainability_export/](https://www.paws-r-sdk.com/docs/forecastservice_create_explainability_export/) for full documentation.
#'
#' @param ExplainabilityExportName &#91;required&#93; A unique name for the Explainability export.
#' @param ExplainabilityArn &#91;required&#93; The Amazon Resource Name (ARN) of the Explainability to export.
#' @param Destination &#91;required&#93; 
#' @param Tags Optional metadata to help you categorize and organize your resources.
#' Each tag consists of a key and an optional value, both of which you
#' define. Tag keys and values are case sensitive.
#' 
#' The following restrictions apply to tags:
#' 
#' -   For each resource, each tag key must be unique and each tag key must
#'     have one value.
#' 
#' -   Maximum number of tags per resource: 50.
#' 
#' -   Maximum key length: 128 Unicode characters in UTF-8.
#' 
#' -   Maximum value length: 256 Unicode characters in UTF-8.
#' 
#' -   Accepted characters: all letters and numbers, spaces representable
#'     in UTF-8, and + - = . _ : / @@. If your tagging schema is used
#'     across other services and resources, the character restrictions of
#'     those services also apply.
#' 
#' -   Key prefixes cannot include any upper or lowercase combination of
#'     `aws:` or `AWS:`. Values can have this prefix. If a tag value has
#'     `aws` as its prefix but the key does not, Forecast considers it to
#'     be a user tag and will count against the limit of 50 tags. Tags with
#'     only the key prefix of `aws` do not count against your tags per
#'     resource limit. You cannot edit or delete tag keys with this prefix.
#' @param Format The format of the exported data, CSV or PARQUET.
#'
#' @keywords internal
#'
#' @rdname forecastservice_create_explainability_export
forecastservice_create_explainability_export <- function(ExplainabilityExportName, ExplainabilityArn, Destination, Tags = NULL, Format = NULL) {
  op <- new_operation(
    name = "CreateExplainabilityExport",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$create_explainability_export_input(ExplainabilityExportName = ExplainabilityExportName, ExplainabilityArn = ExplainabilityArn, Destination = Destination, Tags = Tags, Format = Format)
  output <- .forecastservice$create_explainability_export_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$create_explainability_export <- forecastservice_create_explainability_export

#' Creates a forecast for each item in the TARGET_TIME_SERIES dataset that
#' was used to train the predictor
#'
#' @description
#' Creates a forecast for each item in the `TARGET_TIME_SERIES` dataset that was used to train the predictor. This is known as inference. To retrieve the forecast for a single item at low latency, use the operation. To export the complete forecast into your Amazon Simple Storage Service (Amazon S3) bucket, use the [`create_forecast_export_job`][forecastservice_create_forecast_export_job] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_create_forecast/](https://www.paws-r-sdk.com/docs/forecastservice_create_forecast/) for full documentation.
#'
#' @param ForecastName &#91;required&#93; A name for the forecast.
#' @param PredictorArn &#91;required&#93; The Amazon Resource Name (ARN) of the predictor to use to generate the
#' forecast.
#' @param ForecastTypes The quantiles at which probabilistic forecasts are generated. **You can
#' currently specify up to 5 quantiles per forecast**. Accepted values
#' include `0.01 to 0.99` (increments of .01 only) and `mean`. The mean
#' forecast is different from the median (0.50) when the distribution is
#' not symmetric (for example, Beta and Negative Binomial).
#' 
#' The default quantiles are the quantiles you specified during predictor
#' creation. If you didn't specify quantiles, the default values are
#' `["0.1", "0.5", "0.9"]`.
#' @param Tags The optional metadata that you apply to the forecast to help you
#' categorize and organize them. Each tag consists of a key and an optional
#' value, both of which you define.
#' 
#' The following basic restrictions apply to tags:
#' 
#' -   Maximum number of tags per resource - 50.
#' 
#' -   For each resource, each tag key must be unique, and each tag key can
#'     have only one value.
#' 
#' -   Maximum key length - 128 Unicode characters in UTF-8.
#' 
#' -   Maximum value length - 256 Unicode characters in UTF-8.
#' 
#' -   If your tagging schema is used across multiple services and
#'     resources, remember that other services may have restrictions on
#'     allowed characters. Generally allowed characters are: letters,
#'     numbers, and spaces representable in UTF-8, and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Tag keys and values are case sensitive.
#' 
#' -   Do not use `aws:`, `AWS:`, or any upper or lowercase combination of
#'     such as a prefix for keys as it is reserved for Amazon Web Services
#'     use. You cannot edit or delete tag keys with this prefix. Values can
#'     have this prefix. If a tag value has `aws` as its prefix but the key
#'     does not, then Forecast considers it to be a user tag and will count
#'     against the limit of 50 tags. Tags with only the key prefix of `aws`
#'     do not count against your tags per resource limit.
#' @param TimeSeriesSelector Defines the set of time series that are used to create the forecasts in
#' a `TimeSeriesIdentifiers` object.
#' 
#' The `TimeSeriesIdentifiers` object needs the following information:
#' 
#' -   `DataSource`
#' 
#' -   `Format`
#' 
#' -   `Schema`
#'
#' @keywords internal
#'
#' @rdname forecastservice_create_forecast
forecastservice_create_forecast <- function(ForecastName, PredictorArn, ForecastTypes = NULL, Tags = NULL, TimeSeriesSelector = NULL) {
  op <- new_operation(
    name = "CreateForecast",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$create_forecast_input(ForecastName = ForecastName, PredictorArn = PredictorArn, ForecastTypes = ForecastTypes, Tags = Tags, TimeSeriesSelector = TimeSeriesSelector)
  output <- .forecastservice$create_forecast_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$create_forecast <- forecastservice_create_forecast

#' Exports a forecast created by the CreateForecast operation to your
#' Amazon Simple Storage Service (Amazon S3) bucket
#'
#' @description
#' Exports a forecast created by the [`create_forecast`][forecastservice_create_forecast] operation to your Amazon Simple Storage Service (Amazon S3) bucket. The forecast file name will match the following conventions:
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_create_forecast_export_job/](https://www.paws-r-sdk.com/docs/forecastservice_create_forecast_export_job/) for full documentation.
#'
#' @param ForecastExportJobName &#91;required&#93; The name for the forecast export job.
#' @param ForecastArn &#91;required&#93; The Amazon Resource Name (ARN) of the forecast that you want to export.
#' @param Destination &#91;required&#93; The location where you want to save the forecast and an Identity and
#' Access Management (IAM) role that Amazon Forecast can assume to access
#' the location. The forecast must be exported to an Amazon S3 bucket.
#' 
#' If encryption is used, `Destination` must include an Key Management
#' Service (KMS) key. The IAM role must allow Amazon Forecast permission to
#' access the key.
#' @param Tags The optional metadata that you apply to the forecast export job to help
#' you categorize and organize them. Each tag consists of a key and an
#' optional value, both of which you define.
#' 
#' The following basic restrictions apply to tags:
#' 
#' -   Maximum number of tags per resource - 50.
#' 
#' -   For each resource, each tag key must be unique, and each tag key can
#'     have only one value.
#' 
#' -   Maximum key length - 128 Unicode characters in UTF-8.
#' 
#' -   Maximum value length - 256 Unicode characters in UTF-8.
#' 
#' -   If your tagging schema is used across multiple services and
#'     resources, remember that other services may have restrictions on
#'     allowed characters. Generally allowed characters are: letters,
#'     numbers, and spaces representable in UTF-8, and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Tag keys and values are case sensitive.
#' 
#' -   Do not use `aws:`, `AWS:`, or any upper or lowercase combination of
#'     such as a prefix for keys as it is reserved for Amazon Web Services
#'     use. You cannot edit or delete tag keys with this prefix. Values can
#'     have this prefix. If a tag value has `aws` as its prefix but the key
#'     does not, then Forecast considers it to be a user tag and will count
#'     against the limit of 50 tags. Tags with only the key prefix of `aws`
#'     do not count against your tags per resource limit.
#' @param Format The format of the exported data, CSV or PARQUET. The default value is
#' CSV.
#'
#' @keywords internal
#'
#' @rdname forecastservice_create_forecast_export_job
forecastservice_create_forecast_export_job <- function(ForecastExportJobName, ForecastArn, Destination, Tags = NULL, Format = NULL) {
  op <- new_operation(
    name = "CreateForecastExportJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$create_forecast_export_job_input(ForecastExportJobName = ForecastExportJobName, ForecastArn = ForecastArn, Destination = Destination, Tags = Tags, Format = Format)
  output <- .forecastservice$create_forecast_export_job_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$create_forecast_export_job <- forecastservice_create_forecast_export_job

#' Creates a predictor monitor resource for an existing auto predictor
#'
#' @description
#' Creates a predictor monitor resource for an existing auto predictor. Predictor monitoring allows you to see how your predictor's performance changes over time. For more information, see [Predictor Monitoring](https://docs.aws.amazon.com/forecast/latest/dg/predictor-monitoring.html).
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_create_monitor/](https://www.paws-r-sdk.com/docs/forecastservice_create_monitor/) for full documentation.
#'
#' @param MonitorName &#91;required&#93; The name of the monitor resource.
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the predictor to monitor.
#' @param Tags A list of
#' [tags](https://docs.aws.amazon.com/forecast/latest/dg/tagging-forecast-resources.html)
#' to apply to the monitor resource.
#'
#' @keywords internal
#'
#' @rdname forecastservice_create_monitor
forecastservice_create_monitor <- function(MonitorName, ResourceArn, Tags = NULL) {
  op <- new_operation(
    name = "CreateMonitor",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$create_monitor_input(MonitorName = MonitorName, ResourceArn = ResourceArn, Tags = Tags)
  output <- .forecastservice$create_monitor_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$create_monitor <- forecastservice_create_monitor

#' This operation creates a legacy predictor that does not include all the
#' predictor functionalities provided by Amazon Forecast
#'
#' @description
#' This operation creates a legacy predictor that does not include all the predictor functionalities provided by Amazon Forecast. To create a predictor that is compatible with all aspects of Forecast, use [`create_auto_predictor`][forecastservice_create_auto_predictor].
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_create_predictor/](https://www.paws-r-sdk.com/docs/forecastservice_create_predictor/) for full documentation.
#'
#' @param PredictorName &#91;required&#93; A name for the predictor.
#' @param AlgorithmArn The Amazon Resource Name (ARN) of the algorithm to use for model
#' training. Required if `PerformAutoML` is not set to `true`.
#' 
#' **Supported algorithms:**
#' 
#' -   `arn:aws:forecast:::algorithm/ARIMA`
#' 
#' -   `arn:aws:forecast:::algorithm/CNN-QR`
#' 
#' -   `arn:aws:forecast:::algorithm/Deep_AR_Plus`
#' 
#' -   `arn:aws:forecast:::algorithm/ETS`
#' 
#' -   `arn:aws:forecast:::algorithm/NPTS`
#' 
#' -   `arn:aws:forecast:::algorithm/Prophet`
#' @param ForecastHorizon &#91;required&#93; Specifies the number of time-steps that the model is trained to predict.
#' The forecast horizon is also called the prediction length.
#' 
#' For example, if you configure a dataset for daily data collection (using
#' the `DataFrequency` parameter of the
#' [`create_dataset`][forecastservice_create_dataset] operation) and set
#' the forecast horizon to 10, the model returns predictions for 10 days.
#' 
#' The maximum forecast horizon is the lesser of 500 time-steps or 1/3 of
#' the TARGET_TIME_SERIES dataset length.
#' @param ForecastTypes Specifies the forecast types used to train a predictor. You can specify
#' up to five forecast types. Forecast types can be quantiles from 0.01 to
#' 0.99, by increments of 0.01 or higher. You can also specify the mean
#' forecast with `mean`.
#' 
#' The default value is `["0.10", "0.50", "0.9"]`.
#' @param PerformAutoML Whether to perform AutoML. When Amazon Forecast performs AutoML, it
#' evaluates the algorithms it provides and chooses the best algorithm and
#' configuration for your training dataset.
#' 
#' The default value is `false`. In this case, you are required to specify
#' an algorithm.
#' 
#' Set `PerformAutoML` to `true` to have Amazon Forecast perform AutoML.
#' This is a good option if you aren't sure which algorithm is suitable for
#' your training data. In this case, `PerformHPO` must be false.
#' @param AutoMLOverrideStrategy The `LatencyOptimized` AutoML override strategy is only available in
#' private beta. Contact Amazon Web Services Support or your account
#' manager to learn more about access privileges.
#' 
#' Used to overide the default AutoML strategy, which is to optimize
#' predictor accuracy. To apply an AutoML strategy that minimizes training
#' time, use `LatencyOptimized`.
#' 
#' This parameter is only valid for predictors trained using AutoML.
#' @param PerformHPO Whether to perform hyperparameter optimization (HPO). HPO finds optimal
#' hyperparameter values for your training data. The process of performing
#' HPO is known as running a hyperparameter tuning job.
#' 
#' The default value is `false`. In this case, Amazon Forecast uses default
#' hyperparameter values from the chosen algorithm.
#' 
#' To override the default values, set `PerformHPO` to `true` and,
#' optionally, supply the HyperParameterTuningJobConfig object. The tuning
#' job specifies a metric to optimize, which hyperparameters participate in
#' tuning, and the valid range for each tunable hyperparameter. In this
#' case, you are required to specify an algorithm and `PerformAutoML` must
#' be false.
#' 
#' The following algorithms support HPO:
#' 
#' -   DeepAR+
#' 
#' -   CNN-QR
#' @param TrainingParameters The hyperparameters to override for model training. The hyperparameters
#' that you can override are listed in the individual algorithms. For the
#' list of supported algorithms, see aws-forecast-choosing-recipes.
#' @param EvaluationParameters Used to override the default evaluation parameters of the specified
#' algorithm. Amazon Forecast evaluates a predictor by splitting a dataset
#' into training data and testing data. The evaluation parameters define
#' how to perform the split and the number of iterations.
#' @param HPOConfig Provides hyperparameter override values for the algorithm. If you don't
#' provide this parameter, Amazon Forecast uses default values. The
#' individual algorithms specify which hyperparameters support
#' hyperparameter optimization (HPO). For more information, see
#' aws-forecast-choosing-recipes.
#' 
#' If you included the `HPOConfig` object, you must set `PerformHPO` to
#' true.
#' @param InputDataConfig &#91;required&#93; Describes the dataset group that contains the data to use to train the
#' predictor.
#' @param FeaturizationConfig &#91;required&#93; The featurization configuration.
#' @param EncryptionConfig An Key Management Service (KMS) key and the Identity and Access
#' Management (IAM) role that Amazon Forecast can assume to access the key.
#' @param Tags The optional metadata that you apply to the predictor to help you
#' categorize and organize them. Each tag consists of a key and an optional
#' value, both of which you define.
#' 
#' The following basic restrictions apply to tags:
#' 
#' -   Maximum number of tags per resource - 50.
#' 
#' -   For each resource, each tag key must be unique, and each tag key can
#'     have only one value.
#' 
#' -   Maximum key length - 128 Unicode characters in UTF-8.
#' 
#' -   Maximum value length - 256 Unicode characters in UTF-8.
#' 
#' -   If your tagging schema is used across multiple services and
#'     resources, remember that other services may have restrictions on
#'     allowed characters. Generally allowed characters are: letters,
#'     numbers, and spaces representable in UTF-8, and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Tag keys and values are case sensitive.
#' 
#' -   Do not use `aws:`, `AWS:`, or any upper or lowercase combination of
#'     such as a prefix for keys as it is reserved for Amazon Web Services
#'     use. You cannot edit or delete tag keys with this prefix. Values can
#'     have this prefix. If a tag value has `aws` as its prefix but the key
#'     does not, then Forecast considers it to be a user tag and will count
#'     against the limit of 50 tags. Tags with only the key prefix of `aws`
#'     do not count against your tags per resource limit.
#' @param OptimizationMetric The accuracy metric used to optimize the predictor.
#'
#' @keywords internal
#'
#' @rdname forecastservice_create_predictor
forecastservice_create_predictor <- function(PredictorName, AlgorithmArn = NULL, ForecastHorizon, ForecastTypes = NULL, PerformAutoML = NULL, AutoMLOverrideStrategy = NULL, PerformHPO = NULL, TrainingParameters = NULL, EvaluationParameters = NULL, HPOConfig = NULL, InputDataConfig, FeaturizationConfig, EncryptionConfig = NULL, Tags = NULL, OptimizationMetric = NULL) {
  op <- new_operation(
    name = "CreatePredictor",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$create_predictor_input(PredictorName = PredictorName, AlgorithmArn = AlgorithmArn, ForecastHorizon = ForecastHorizon, ForecastTypes = ForecastTypes, PerformAutoML = PerformAutoML, AutoMLOverrideStrategy = AutoMLOverrideStrategy, PerformHPO = PerformHPO, TrainingParameters = TrainingParameters, EvaluationParameters = EvaluationParameters, HPOConfig = HPOConfig, InputDataConfig = InputDataConfig, FeaturizationConfig = FeaturizationConfig, EncryptionConfig = EncryptionConfig, Tags = Tags, OptimizationMetric = OptimizationMetric)
  output <- .forecastservice$create_predictor_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$create_predictor <- forecastservice_create_predictor

#' Exports backtest forecasts and accuracy metrics generated by the
#' CreateAutoPredictor or CreatePredictor operations
#'
#' @description
#' Exports backtest forecasts and accuracy metrics generated by the [`create_auto_predictor`][forecastservice_create_auto_predictor] or [`create_predictor`][forecastservice_create_predictor] operations. Two folders containing CSV or Parquet files are exported to your specified S3 bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_create_predictor_backtest_export_job/](https://www.paws-r-sdk.com/docs/forecastservice_create_predictor_backtest_export_job/) for full documentation.
#'
#' @param PredictorBacktestExportJobName &#91;required&#93; The name for the backtest export job.
#' @param PredictorArn &#91;required&#93; The Amazon Resource Name (ARN) of the predictor that you want to export.
#' @param Destination &#91;required&#93; 
#' @param Tags Optional metadata to help you categorize and organize your backtests.
#' Each tag consists of a key and an optional value, both of which you
#' define. Tag keys and values are case sensitive.
#' 
#' The following restrictions apply to tags:
#' 
#' -   For each resource, each tag key must be unique and each tag key must
#'     have one value.
#' 
#' -   Maximum number of tags per resource: 50.
#' 
#' -   Maximum key length: 128 Unicode characters in UTF-8.
#' 
#' -   Maximum value length: 256 Unicode characters in UTF-8.
#' 
#' -   Accepted characters: all letters and numbers, spaces representable
#'     in UTF-8, and + - = . _ : / @@. If your tagging schema is used
#'     across other services and resources, the character restrictions of
#'     those services also apply.
#' 
#' -   Key prefixes cannot include any upper or lowercase combination of
#'     `aws:` or `AWS:`. Values can have this prefix. If a tag value has
#'     `aws` as its prefix but the key does not, Forecast considers it to
#'     be a user tag and will count against the limit of 50 tags. Tags with
#'     only the key prefix of `aws` do not count against your tags per
#'     resource limit. You cannot edit or delete tag keys with this prefix.
#' @param Format The format of the exported data, CSV or PARQUET. The default value is
#' CSV.
#'
#' @keywords internal
#'
#' @rdname forecastservice_create_predictor_backtest_export_job
forecastservice_create_predictor_backtest_export_job <- function(PredictorBacktestExportJobName, PredictorArn, Destination, Tags = NULL, Format = NULL) {
  op <- new_operation(
    name = "CreatePredictorBacktestExportJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$create_predictor_backtest_export_job_input(PredictorBacktestExportJobName = PredictorBacktestExportJobName, PredictorArn = PredictorArn, Destination = Destination, Tags = Tags, Format = Format)
  output <- .forecastservice$create_predictor_backtest_export_job_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$create_predictor_backtest_export_job <- forecastservice_create_predictor_backtest_export_job

#' What-if analysis is a scenario modeling technique where you make a
#' hypothetical change to a time series and compare the forecasts generated
#' by these changes against the baseline, unchanged time series
#'
#' @description
#' What-if analysis is a scenario modeling technique where you make a hypothetical change to a time series and compare the forecasts generated by these changes against the baseline, unchanged time series. It is important to remember that the purpose of a what-if analysis is to understand how a forecast can change given different modifications to the baseline time series.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_create_what_if_analysis/](https://www.paws-r-sdk.com/docs/forecastservice_create_what_if_analysis/) for full documentation.
#'
#' @param WhatIfAnalysisName &#91;required&#93; The name of the what-if analysis. Each name must be unique.
#' @param ForecastArn &#91;required&#93; The Amazon Resource Name (ARN) of the baseline forecast.
#' @param TimeSeriesSelector Defines the set of time series that are used in the what-if analysis
#' with a `TimeSeriesIdentifiers` object. What-if analyses are performed
#' only for the time series in this object.
#' 
#' The `TimeSeriesIdentifiers` object needs the following information:
#' 
#' -   `DataSource`
#' 
#' -   `Format`
#' 
#' -   `Schema`
#' @param Tags A list of
#' [tags](https://docs.aws.amazon.com/forecast/latest/dg/tagging-forecast-resources.html)
#' to apply to the what if forecast.
#'
#' @keywords internal
#'
#' @rdname forecastservice_create_what_if_analysis
forecastservice_create_what_if_analysis <- function(WhatIfAnalysisName, ForecastArn, TimeSeriesSelector = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateWhatIfAnalysis",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$create_what_if_analysis_input(WhatIfAnalysisName = WhatIfAnalysisName, ForecastArn = ForecastArn, TimeSeriesSelector = TimeSeriesSelector, Tags = Tags)
  output <- .forecastservice$create_what_if_analysis_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$create_what_if_analysis <- forecastservice_create_what_if_analysis

#' A what-if forecast is a forecast that is created from a modified version
#' of the baseline forecast
#'
#' @description
#' A what-if forecast is a forecast that is created from a modified version of the baseline forecast. Each what-if forecast incorporates either a replacement dataset or a set of transformations to the original dataset.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_create_what_if_forecast/](https://www.paws-r-sdk.com/docs/forecastservice_create_what_if_forecast/) for full documentation.
#'
#' @param WhatIfForecastName &#91;required&#93; The name of the what-if forecast. Names must be unique within each
#' what-if analysis.
#' @param WhatIfAnalysisArn &#91;required&#93; The Amazon Resource Name (ARN) of the what-if analysis.
#' @param TimeSeriesTransformations The transformations that are applied to the baseline time series. Each
#' transformation contains an action and a set of conditions. An action is
#' applied only when all conditions are met. If no conditions are provided,
#' the action is applied to all items.
#' @param TimeSeriesReplacementsDataSource The replacement time series dataset, which contains the rows that you
#' want to change in the related time series dataset. A replacement time
#' series does not need to contain all rows that are in the baseline
#' related time series. Include only the rows (measure-dimension
#' combinations) that you want to include in the what-if forecast.
#' 
#' This dataset is merged with the original time series to create a
#' transformed dataset that is used for the what-if analysis.
#' 
#' This dataset should contain the items to modify (such as item_id or
#' workforce_type), any relevant dimensions, the timestamp column, and at
#' least one of the related time series columns. This file should not
#' contain duplicate timestamps for the same time series.
#' 
#' Timestamps and item_ids not included in this dataset are not included in
#' the what-if analysis.
#' @param Tags A list of
#' [tags](https://docs.aws.amazon.com/forecast/latest/dg/tagging-forecast-resources.html)
#' to apply to the what if forecast.
#'
#' @keywords internal
#'
#' @rdname forecastservice_create_what_if_forecast
forecastservice_create_what_if_forecast <- function(WhatIfForecastName, WhatIfAnalysisArn, TimeSeriesTransformations = NULL, TimeSeriesReplacementsDataSource = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateWhatIfForecast",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$create_what_if_forecast_input(WhatIfForecastName = WhatIfForecastName, WhatIfAnalysisArn = WhatIfAnalysisArn, TimeSeriesTransformations = TimeSeriesTransformations, TimeSeriesReplacementsDataSource = TimeSeriesReplacementsDataSource, Tags = Tags)
  output <- .forecastservice$create_what_if_forecast_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$create_what_if_forecast <- forecastservice_create_what_if_forecast

#' Exports a forecast created by the CreateWhatIfForecast operation to your
#' Amazon Simple Storage Service (Amazon S3) bucket
#'
#' @description
#' Exports a forecast created by the [`create_what_if_forecast`][forecastservice_create_what_if_forecast] operation to your Amazon Simple Storage Service (Amazon S3) bucket. The forecast file name will match the following conventions:
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_create_what_if_forecast_export/](https://www.paws-r-sdk.com/docs/forecastservice_create_what_if_forecast_export/) for full documentation.
#'
#' @param WhatIfForecastExportName &#91;required&#93; The name of the what-if forecast to export.
#' @param WhatIfForecastArns &#91;required&#93; The list of what-if forecast Amazon Resource Names (ARNs) to export.
#' @param Destination &#91;required&#93; The location where you want to save the forecast and an Identity and
#' Access Management (IAM) role that Amazon Forecast can assume to access
#' the location. The forecast must be exported to an Amazon S3 bucket.
#' 
#' If encryption is used, `Destination` must include an Key Management
#' Service (KMS) key. The IAM role must allow Amazon Forecast permission to
#' access the key.
#' @param Tags A list of
#' [tags](https://docs.aws.amazon.com/forecast/latest/dg/tagging-forecast-resources.html)
#' to apply to the what if forecast.
#' @param Format The format of the exported data, CSV or PARQUET.
#'
#' @keywords internal
#'
#' @rdname forecastservice_create_what_if_forecast_export
forecastservice_create_what_if_forecast_export <- function(WhatIfForecastExportName, WhatIfForecastArns, Destination, Tags = NULL, Format = NULL) {
  op <- new_operation(
    name = "CreateWhatIfForecastExport",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$create_what_if_forecast_export_input(WhatIfForecastExportName = WhatIfForecastExportName, WhatIfForecastArns = WhatIfForecastArns, Destination = Destination, Tags = Tags, Format = Format)
  output <- .forecastservice$create_what_if_forecast_export_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$create_what_if_forecast_export <- forecastservice_create_what_if_forecast_export

#' Deletes an Amazon Forecast dataset that was created using the
#' CreateDataset operation
#'
#' @description
#' Deletes an Amazon Forecast dataset that was created using the [`create_dataset`][forecastservice_create_dataset] operation. You can only delete datasets that have a status of `ACTIVE` or `CREATE_FAILED`. To get the status use the [`describe_dataset`][forecastservice_describe_dataset] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_delete_dataset/](https://www.paws-r-sdk.com/docs/forecastservice_delete_dataset/) for full documentation.
#'
#' @param DatasetArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset to delete.
#'
#' @keywords internal
#'
#' @rdname forecastservice_delete_dataset
forecastservice_delete_dataset <- function(DatasetArn) {
  op <- new_operation(
    name = "DeleteDataset",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$delete_dataset_input(DatasetArn = DatasetArn)
  output <- .forecastservice$delete_dataset_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$delete_dataset <- forecastservice_delete_dataset

#' Deletes a dataset group created using the CreateDatasetGroup operation
#'
#' @description
#' Deletes a dataset group created using the [`create_dataset_group`][forecastservice_create_dataset_group] operation. You can only delete dataset groups that have a status of `ACTIVE`, `CREATE_FAILED`, or `UPDATE_FAILED`. To get the status, use the [`describe_dataset_group`][forecastservice_describe_dataset_group] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_delete_dataset_group/](https://www.paws-r-sdk.com/docs/forecastservice_delete_dataset_group/) for full documentation.
#'
#' @param DatasetGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset group to delete.
#'
#' @keywords internal
#'
#' @rdname forecastservice_delete_dataset_group
forecastservice_delete_dataset_group <- function(DatasetGroupArn) {
  op <- new_operation(
    name = "DeleteDatasetGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$delete_dataset_group_input(DatasetGroupArn = DatasetGroupArn)
  output <- .forecastservice$delete_dataset_group_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$delete_dataset_group <- forecastservice_delete_dataset_group

#' Deletes a dataset import job created using the CreateDatasetImportJob
#' operation
#'
#' @description
#' Deletes a dataset import job created using the [`create_dataset_import_job`][forecastservice_create_dataset_import_job] operation. You can delete only dataset import jobs that have a status of `ACTIVE` or `CREATE_FAILED`. To get the status, use the [`describe_dataset_import_job`][forecastservice_describe_dataset_import_job] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_delete_dataset_import_job/](https://www.paws-r-sdk.com/docs/forecastservice_delete_dataset_import_job/) for full documentation.
#'
#' @param DatasetImportJobArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset import job to delete.
#'
#' @keywords internal
#'
#' @rdname forecastservice_delete_dataset_import_job
forecastservice_delete_dataset_import_job <- function(DatasetImportJobArn) {
  op <- new_operation(
    name = "DeleteDatasetImportJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$delete_dataset_import_job_input(DatasetImportJobArn = DatasetImportJobArn)
  output <- .forecastservice$delete_dataset_import_job_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$delete_dataset_import_job <- forecastservice_delete_dataset_import_job

#' Deletes an Explainability resource
#'
#' @description
#' Deletes an Explainability resource.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_delete_explainability/](https://www.paws-r-sdk.com/docs/forecastservice_delete_explainability/) for full documentation.
#'
#' @param ExplainabilityArn &#91;required&#93; The Amazon Resource Name (ARN) of the Explainability resource to delete.
#'
#' @keywords internal
#'
#' @rdname forecastservice_delete_explainability
forecastservice_delete_explainability <- function(ExplainabilityArn) {
  op <- new_operation(
    name = "DeleteExplainability",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$delete_explainability_input(ExplainabilityArn = ExplainabilityArn)
  output <- .forecastservice$delete_explainability_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$delete_explainability <- forecastservice_delete_explainability

#' Deletes an Explainability export
#'
#' @description
#' Deletes an Explainability export.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_delete_explainability_export/](https://www.paws-r-sdk.com/docs/forecastservice_delete_explainability_export/) for full documentation.
#'
#' @param ExplainabilityExportArn &#91;required&#93; The Amazon Resource Name (ARN) of the Explainability export to delete.
#'
#' @keywords internal
#'
#' @rdname forecastservice_delete_explainability_export
forecastservice_delete_explainability_export <- function(ExplainabilityExportArn) {
  op <- new_operation(
    name = "DeleteExplainabilityExport",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$delete_explainability_export_input(ExplainabilityExportArn = ExplainabilityExportArn)
  output <- .forecastservice$delete_explainability_export_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$delete_explainability_export <- forecastservice_delete_explainability_export

#' Deletes a forecast created using the CreateForecast operation
#'
#' @description
#' Deletes a forecast created using the [`create_forecast`][forecastservice_create_forecast] operation. You can delete only forecasts that have a status of `ACTIVE` or `CREATE_FAILED`. To get the status, use the [`describe_forecast`][forecastservice_describe_forecast] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_delete_forecast/](https://www.paws-r-sdk.com/docs/forecastservice_delete_forecast/) for full documentation.
#'
#' @param ForecastArn &#91;required&#93; The Amazon Resource Name (ARN) of the forecast to delete.
#'
#' @keywords internal
#'
#' @rdname forecastservice_delete_forecast
forecastservice_delete_forecast <- function(ForecastArn) {
  op <- new_operation(
    name = "DeleteForecast",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$delete_forecast_input(ForecastArn = ForecastArn)
  output <- .forecastservice$delete_forecast_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$delete_forecast <- forecastservice_delete_forecast

#' Deletes a forecast export job created using the CreateForecastExportJob
#' operation
#'
#' @description
#' Deletes a forecast export job created using the [`create_forecast_export_job`][forecastservice_create_forecast_export_job] operation. You can delete only export jobs that have a status of `ACTIVE` or `CREATE_FAILED`. To get the status, use the [`describe_forecast_export_job`][forecastservice_describe_forecast_export_job] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_delete_forecast_export_job/](https://www.paws-r-sdk.com/docs/forecastservice_delete_forecast_export_job/) for full documentation.
#'
#' @param ForecastExportJobArn &#91;required&#93; The Amazon Resource Name (ARN) of the forecast export job to delete.
#'
#' @keywords internal
#'
#' @rdname forecastservice_delete_forecast_export_job
forecastservice_delete_forecast_export_job <- function(ForecastExportJobArn) {
  op <- new_operation(
    name = "DeleteForecastExportJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$delete_forecast_export_job_input(ForecastExportJobArn = ForecastExportJobArn)
  output <- .forecastservice$delete_forecast_export_job_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$delete_forecast_export_job <- forecastservice_delete_forecast_export_job

#' Deletes a monitor resource
#'
#' @description
#' Deletes a monitor resource. You can only delete a monitor resource with a status of `ACTIVE`, `ACTIVE_STOPPED`, `CREATE_FAILED`, or `CREATE_STOPPED`.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_delete_monitor/](https://www.paws-r-sdk.com/docs/forecastservice_delete_monitor/) for full documentation.
#'
#' @param MonitorArn &#91;required&#93; The Amazon Resource Name (ARN) of the monitor resource to delete.
#'
#' @keywords internal
#'
#' @rdname forecastservice_delete_monitor
forecastservice_delete_monitor <- function(MonitorArn) {
  op <- new_operation(
    name = "DeleteMonitor",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$delete_monitor_input(MonitorArn = MonitorArn)
  output <- .forecastservice$delete_monitor_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$delete_monitor <- forecastservice_delete_monitor

#' Deletes a predictor created using the DescribePredictor or
#' CreatePredictor operations
#'
#' @description
#' Deletes a predictor created using the [`describe_predictor`][forecastservice_describe_predictor] or [`create_predictor`][forecastservice_create_predictor] operations. You can delete only predictor that have a status of `ACTIVE` or `CREATE_FAILED`. To get the status, use the [`describe_predictor`][forecastservice_describe_predictor] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_delete_predictor/](https://www.paws-r-sdk.com/docs/forecastservice_delete_predictor/) for full documentation.
#'
#' @param PredictorArn &#91;required&#93; The Amazon Resource Name (ARN) of the predictor to delete.
#'
#' @keywords internal
#'
#' @rdname forecastservice_delete_predictor
forecastservice_delete_predictor <- function(PredictorArn) {
  op <- new_operation(
    name = "DeletePredictor",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$delete_predictor_input(PredictorArn = PredictorArn)
  output <- .forecastservice$delete_predictor_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$delete_predictor <- forecastservice_delete_predictor

#' Deletes a predictor backtest export job
#'
#' @description
#' Deletes a predictor backtest export job.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_delete_predictor_backtest_export_job/](https://www.paws-r-sdk.com/docs/forecastservice_delete_predictor_backtest_export_job/) for full documentation.
#'
#' @param PredictorBacktestExportJobArn &#91;required&#93; The Amazon Resource Name (ARN) of the predictor backtest export job to
#' delete.
#'
#' @keywords internal
#'
#' @rdname forecastservice_delete_predictor_backtest_export_job
forecastservice_delete_predictor_backtest_export_job <- function(PredictorBacktestExportJobArn) {
  op <- new_operation(
    name = "DeletePredictorBacktestExportJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$delete_predictor_backtest_export_job_input(PredictorBacktestExportJobArn = PredictorBacktestExportJobArn)
  output <- .forecastservice$delete_predictor_backtest_export_job_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$delete_predictor_backtest_export_job <- forecastservice_delete_predictor_backtest_export_job

#' Deletes an entire resource tree
#'
#' @description
#' Deletes an entire resource tree. This operation will delete the parent resource and its child resources.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_delete_resource_tree/](https://www.paws-r-sdk.com/docs/forecastservice_delete_resource_tree/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the parent resource to delete. All
#' child resources of the parent resource will also be deleted.
#'
#' @keywords internal
#'
#' @rdname forecastservice_delete_resource_tree
forecastservice_delete_resource_tree <- function(ResourceArn) {
  op <- new_operation(
    name = "DeleteResourceTree",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$delete_resource_tree_input(ResourceArn = ResourceArn)
  output <- .forecastservice$delete_resource_tree_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$delete_resource_tree <- forecastservice_delete_resource_tree

#' Deletes a what-if analysis created using the CreateWhatIfAnalysis
#' operation
#'
#' @description
#' Deletes a what-if analysis created using the [`create_what_if_analysis`][forecastservice_create_what_if_analysis] operation. You can delete only what-if analyses that have a status of `ACTIVE` or `CREATE_FAILED`. To get the status, use the [`describe_what_if_analysis`][forecastservice_describe_what_if_analysis] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_delete_what_if_analysis/](https://www.paws-r-sdk.com/docs/forecastservice_delete_what_if_analysis/) for full documentation.
#'
#' @param WhatIfAnalysisArn &#91;required&#93; The Amazon Resource Name (ARN) of the what-if analysis that you want to
#' delete.
#'
#' @keywords internal
#'
#' @rdname forecastservice_delete_what_if_analysis
forecastservice_delete_what_if_analysis <- function(WhatIfAnalysisArn) {
  op <- new_operation(
    name = "DeleteWhatIfAnalysis",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$delete_what_if_analysis_input(WhatIfAnalysisArn = WhatIfAnalysisArn)
  output <- .forecastservice$delete_what_if_analysis_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$delete_what_if_analysis <- forecastservice_delete_what_if_analysis

#' Deletes a what-if forecast created using the CreateWhatIfForecast
#' operation
#'
#' @description
#' Deletes a what-if forecast created using the [`create_what_if_forecast`][forecastservice_create_what_if_forecast] operation. You can delete only what-if forecasts that have a status of `ACTIVE` or `CREATE_FAILED`. To get the status, use the [`describe_what_if_forecast`][forecastservice_describe_what_if_forecast] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_delete_what_if_forecast/](https://www.paws-r-sdk.com/docs/forecastservice_delete_what_if_forecast/) for full documentation.
#'
#' @param WhatIfForecastArn &#91;required&#93; The Amazon Resource Name (ARN) of the what-if forecast that you want to
#' delete.
#'
#' @keywords internal
#'
#' @rdname forecastservice_delete_what_if_forecast
forecastservice_delete_what_if_forecast <- function(WhatIfForecastArn) {
  op <- new_operation(
    name = "DeleteWhatIfForecast",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$delete_what_if_forecast_input(WhatIfForecastArn = WhatIfForecastArn)
  output <- .forecastservice$delete_what_if_forecast_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$delete_what_if_forecast <- forecastservice_delete_what_if_forecast

#' Deletes a what-if forecast export created using the
#' CreateWhatIfForecastExport operation
#'
#' @description
#' Deletes a what-if forecast export created using the [`create_what_if_forecast_export`][forecastservice_create_what_if_forecast_export] operation. You can delete only what-if forecast exports that have a status of `ACTIVE` or `CREATE_FAILED`. To get the status, use the [`describe_what_if_forecast_export`][forecastservice_describe_what_if_forecast_export] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_delete_what_if_forecast_export/](https://www.paws-r-sdk.com/docs/forecastservice_delete_what_if_forecast_export/) for full documentation.
#'
#' @param WhatIfForecastExportArn &#91;required&#93; The Amazon Resource Name (ARN) of the what-if forecast export that you
#' want to delete.
#'
#' @keywords internal
#'
#' @rdname forecastservice_delete_what_if_forecast_export
forecastservice_delete_what_if_forecast_export <- function(WhatIfForecastExportArn) {
  op <- new_operation(
    name = "DeleteWhatIfForecastExport",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$delete_what_if_forecast_export_input(WhatIfForecastExportArn = WhatIfForecastExportArn)
  output <- .forecastservice$delete_what_if_forecast_export_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$delete_what_if_forecast_export <- forecastservice_delete_what_if_forecast_export

#' Describes a predictor created using the CreateAutoPredictor operation
#'
#' @description
#' Describes a predictor created using the CreateAutoPredictor operation.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_describe_auto_predictor/](https://www.paws-r-sdk.com/docs/forecastservice_describe_auto_predictor/) for full documentation.
#'
#' @param PredictorArn &#91;required&#93; The Amazon Resource Name (ARN) of the predictor.
#'
#' @keywords internal
#'
#' @rdname forecastservice_describe_auto_predictor
forecastservice_describe_auto_predictor <- function(PredictorArn) {
  op <- new_operation(
    name = "DescribeAutoPredictor",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$describe_auto_predictor_input(PredictorArn = PredictorArn)
  output <- .forecastservice$describe_auto_predictor_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$describe_auto_predictor <- forecastservice_describe_auto_predictor

#' Describes an Amazon Forecast dataset created using the CreateDataset
#' operation
#'
#' @description
#' Describes an Amazon Forecast dataset created using the [`create_dataset`][forecastservice_create_dataset] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_describe_dataset/](https://www.paws-r-sdk.com/docs/forecastservice_describe_dataset/) for full documentation.
#'
#' @param DatasetArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset.
#'
#' @keywords internal
#'
#' @rdname forecastservice_describe_dataset
forecastservice_describe_dataset <- function(DatasetArn) {
  op <- new_operation(
    name = "DescribeDataset",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$describe_dataset_input(DatasetArn = DatasetArn)
  output <- .forecastservice$describe_dataset_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$describe_dataset <- forecastservice_describe_dataset

#' Describes a dataset group created using the CreateDatasetGroup operation
#'
#' @description
#' Describes a dataset group created using the [`create_dataset_group`][forecastservice_create_dataset_group] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_describe_dataset_group/](https://www.paws-r-sdk.com/docs/forecastservice_describe_dataset_group/) for full documentation.
#'
#' @param DatasetGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset group.
#'
#' @keywords internal
#'
#' @rdname forecastservice_describe_dataset_group
forecastservice_describe_dataset_group <- function(DatasetGroupArn) {
  op <- new_operation(
    name = "DescribeDatasetGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$describe_dataset_group_input(DatasetGroupArn = DatasetGroupArn)
  output <- .forecastservice$describe_dataset_group_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$describe_dataset_group <- forecastservice_describe_dataset_group

#' Describes a dataset import job created using the CreateDatasetImportJob
#' operation
#'
#' @description
#' Describes a dataset import job created using the [`create_dataset_import_job`][forecastservice_create_dataset_import_job] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_describe_dataset_import_job/](https://www.paws-r-sdk.com/docs/forecastservice_describe_dataset_import_job/) for full documentation.
#'
#' @param DatasetImportJobArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset import job.
#'
#' @keywords internal
#'
#' @rdname forecastservice_describe_dataset_import_job
forecastservice_describe_dataset_import_job <- function(DatasetImportJobArn) {
  op <- new_operation(
    name = "DescribeDatasetImportJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$describe_dataset_import_job_input(DatasetImportJobArn = DatasetImportJobArn)
  output <- .forecastservice$describe_dataset_import_job_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$describe_dataset_import_job <- forecastservice_describe_dataset_import_job

#' Describes an Explainability resource created using the
#' CreateExplainability operation
#'
#' @description
#' Describes an Explainability resource created using the [`create_explainability`][forecastservice_create_explainability] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_describe_explainability/](https://www.paws-r-sdk.com/docs/forecastservice_describe_explainability/) for full documentation.
#'
#' @param ExplainabilityArn &#91;required&#93; The Amazon Resource Name (ARN) of the Explaianability to describe.
#'
#' @keywords internal
#'
#' @rdname forecastservice_describe_explainability
forecastservice_describe_explainability <- function(ExplainabilityArn) {
  op <- new_operation(
    name = "DescribeExplainability",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$describe_explainability_input(ExplainabilityArn = ExplainabilityArn)
  output <- .forecastservice$describe_explainability_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$describe_explainability <- forecastservice_describe_explainability

#' Describes an Explainability export created using the
#' CreateExplainabilityExport operation
#'
#' @description
#' Describes an Explainability export created using the [`create_explainability_export`][forecastservice_create_explainability_export] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_describe_explainability_export/](https://www.paws-r-sdk.com/docs/forecastservice_describe_explainability_export/) for full documentation.
#'
#' @param ExplainabilityExportArn &#91;required&#93; The Amazon Resource Name (ARN) of the Explainability export.
#'
#' @keywords internal
#'
#' @rdname forecastservice_describe_explainability_export
forecastservice_describe_explainability_export <- function(ExplainabilityExportArn) {
  op <- new_operation(
    name = "DescribeExplainabilityExport",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$describe_explainability_export_input(ExplainabilityExportArn = ExplainabilityExportArn)
  output <- .forecastservice$describe_explainability_export_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$describe_explainability_export <- forecastservice_describe_explainability_export

#' Describes a forecast created using the CreateForecast operation
#'
#' @description
#' Describes a forecast created using the [`create_forecast`][forecastservice_create_forecast] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_describe_forecast/](https://www.paws-r-sdk.com/docs/forecastservice_describe_forecast/) for full documentation.
#'
#' @param ForecastArn &#91;required&#93; The Amazon Resource Name (ARN) of the forecast.
#'
#' @keywords internal
#'
#' @rdname forecastservice_describe_forecast
forecastservice_describe_forecast <- function(ForecastArn) {
  op <- new_operation(
    name = "DescribeForecast",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$describe_forecast_input(ForecastArn = ForecastArn)
  output <- .forecastservice$describe_forecast_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$describe_forecast <- forecastservice_describe_forecast

#' Describes a forecast export job created using the
#' CreateForecastExportJob operation
#'
#' @description
#' Describes a forecast export job created using the [`create_forecast_export_job`][forecastservice_create_forecast_export_job] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_describe_forecast_export_job/](https://www.paws-r-sdk.com/docs/forecastservice_describe_forecast_export_job/) for full documentation.
#'
#' @param ForecastExportJobArn &#91;required&#93; The Amazon Resource Name (ARN) of the forecast export job.
#'
#' @keywords internal
#'
#' @rdname forecastservice_describe_forecast_export_job
forecastservice_describe_forecast_export_job <- function(ForecastExportJobArn) {
  op <- new_operation(
    name = "DescribeForecastExportJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$describe_forecast_export_job_input(ForecastExportJobArn = ForecastExportJobArn)
  output <- .forecastservice$describe_forecast_export_job_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$describe_forecast_export_job <- forecastservice_describe_forecast_export_job

#' Describes a monitor resource
#'
#' @description
#' Describes a monitor resource. In addition to listing the properties provided in the [`create_monitor`][forecastservice_create_monitor] request, this operation lists the following properties:
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_describe_monitor/](https://www.paws-r-sdk.com/docs/forecastservice_describe_monitor/) for full documentation.
#'
#' @param MonitorArn &#91;required&#93; The Amazon Resource Name (ARN) of the monitor resource to describe.
#'
#' @keywords internal
#'
#' @rdname forecastservice_describe_monitor
forecastservice_describe_monitor <- function(MonitorArn) {
  op <- new_operation(
    name = "DescribeMonitor",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$describe_monitor_input(MonitorArn = MonitorArn)
  output <- .forecastservice$describe_monitor_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$describe_monitor <- forecastservice_describe_monitor

#' This operation is only valid for legacy predictors created with
#' CreatePredictor
#'
#' @description
#' This operation is only valid for legacy predictors created with CreatePredictor. If you are not using a legacy predictor, use [`describe_auto_predictor`][forecastservice_describe_auto_predictor].
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_describe_predictor/](https://www.paws-r-sdk.com/docs/forecastservice_describe_predictor/) for full documentation.
#'
#' @param PredictorArn &#91;required&#93; The Amazon Resource Name (ARN) of the predictor that you want
#' information about.
#'
#' @keywords internal
#'
#' @rdname forecastservice_describe_predictor
forecastservice_describe_predictor <- function(PredictorArn) {
  op <- new_operation(
    name = "DescribePredictor",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$describe_predictor_input(PredictorArn = PredictorArn)
  output <- .forecastservice$describe_predictor_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$describe_predictor <- forecastservice_describe_predictor

#' Describes a predictor backtest export job created using the
#' CreatePredictorBacktestExportJob operation
#'
#' @description
#' Describes a predictor backtest export job created using the [`create_predictor_backtest_export_job`][forecastservice_create_predictor_backtest_export_job] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_describe_predictor_backtest_export_job/](https://www.paws-r-sdk.com/docs/forecastservice_describe_predictor_backtest_export_job/) for full documentation.
#'
#' @param PredictorBacktestExportJobArn &#91;required&#93; The Amazon Resource Name (ARN) of the predictor backtest export job.
#'
#' @keywords internal
#'
#' @rdname forecastservice_describe_predictor_backtest_export_job
forecastservice_describe_predictor_backtest_export_job <- function(PredictorBacktestExportJobArn) {
  op <- new_operation(
    name = "DescribePredictorBacktestExportJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$describe_predictor_backtest_export_job_input(PredictorBacktestExportJobArn = PredictorBacktestExportJobArn)
  output <- .forecastservice$describe_predictor_backtest_export_job_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$describe_predictor_backtest_export_job <- forecastservice_describe_predictor_backtest_export_job

#' Describes the what-if analysis created using the CreateWhatIfAnalysis
#' operation
#'
#' @description
#' Describes the what-if analysis created using the [`create_what_if_analysis`][forecastservice_create_what_if_analysis] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_describe_what_if_analysis/](https://www.paws-r-sdk.com/docs/forecastservice_describe_what_if_analysis/) for full documentation.
#'
#' @param WhatIfAnalysisArn &#91;required&#93; The Amazon Resource Name (ARN) of the what-if analysis that you are
#' interested in.
#'
#' @keywords internal
#'
#' @rdname forecastservice_describe_what_if_analysis
forecastservice_describe_what_if_analysis <- function(WhatIfAnalysisArn) {
  op <- new_operation(
    name = "DescribeWhatIfAnalysis",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$describe_what_if_analysis_input(WhatIfAnalysisArn = WhatIfAnalysisArn)
  output <- .forecastservice$describe_what_if_analysis_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$describe_what_if_analysis <- forecastservice_describe_what_if_analysis

#' Describes the what-if forecast created using the CreateWhatIfForecast
#' operation
#'
#' @description
#' Describes the what-if forecast created using the [`create_what_if_forecast`][forecastservice_create_what_if_forecast] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_describe_what_if_forecast/](https://www.paws-r-sdk.com/docs/forecastservice_describe_what_if_forecast/) for full documentation.
#'
#' @param WhatIfForecastArn &#91;required&#93; The Amazon Resource Name (ARN) of the what-if forecast that you are
#' interested in.
#'
#' @keywords internal
#'
#' @rdname forecastservice_describe_what_if_forecast
forecastservice_describe_what_if_forecast <- function(WhatIfForecastArn) {
  op <- new_operation(
    name = "DescribeWhatIfForecast",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$describe_what_if_forecast_input(WhatIfForecastArn = WhatIfForecastArn)
  output <- .forecastservice$describe_what_if_forecast_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$describe_what_if_forecast <- forecastservice_describe_what_if_forecast

#' Describes the what-if forecast export created using the
#' CreateWhatIfForecastExport operation
#'
#' @description
#' Describes the what-if forecast export created using the [`create_what_if_forecast_export`][forecastservice_create_what_if_forecast_export] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_describe_what_if_forecast_export/](https://www.paws-r-sdk.com/docs/forecastservice_describe_what_if_forecast_export/) for full documentation.
#'
#' @param WhatIfForecastExportArn &#91;required&#93; The Amazon Resource Name (ARN) of the what-if forecast export that you
#' are interested in.
#'
#' @keywords internal
#'
#' @rdname forecastservice_describe_what_if_forecast_export
forecastservice_describe_what_if_forecast_export <- function(WhatIfForecastExportArn) {
  op <- new_operation(
    name = "DescribeWhatIfForecastExport",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$describe_what_if_forecast_export_input(WhatIfForecastExportArn = WhatIfForecastExportArn)
  output <- .forecastservice$describe_what_if_forecast_export_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$describe_what_if_forecast_export <- forecastservice_describe_what_if_forecast_export

#' Provides metrics on the accuracy of the models that were trained by the
#' CreatePredictor operation
#'
#' @description
#' Provides metrics on the accuracy of the models that were trained by the [`create_predictor`][forecastservice_create_predictor] operation. Use metrics to see how well the model performed and to decide whether to use the predictor to generate a forecast. For more information, see [Predictor Metrics](https://docs.aws.amazon.com/forecast/latest/dg/metrics.html).
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_get_accuracy_metrics/](https://www.paws-r-sdk.com/docs/forecastservice_get_accuracy_metrics/) for full documentation.
#'
#' @param PredictorArn &#91;required&#93; The Amazon Resource Name (ARN) of the predictor to get metrics for.
#'
#' @keywords internal
#'
#' @rdname forecastservice_get_accuracy_metrics
forecastservice_get_accuracy_metrics <- function(PredictorArn) {
  op <- new_operation(
    name = "GetAccuracyMetrics",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$get_accuracy_metrics_input(PredictorArn = PredictorArn)
  output <- .forecastservice$get_accuracy_metrics_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$get_accuracy_metrics <- forecastservice_get_accuracy_metrics

#' Returns a list of dataset groups created using the CreateDatasetGroup
#' operation
#'
#' @description
#' Returns a list of dataset groups created using the [`create_dataset_group`][forecastservice_create_dataset_group] operation. For each dataset group, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). You can retrieve the complete set of properties by using the dataset group ARN with the [`describe_dataset_group`][forecastservice_describe_dataset_group] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_list_dataset_groups/](https://www.paws-r-sdk.com/docs/forecastservice_list_dataset_groups/) for full documentation.
#'
#' @param NextToken If the result of the previous request was truncated, the response
#' includes a `NextToken`. To retrieve the next set of results, use the
#' token in the next request. Tokens expire after 24 hours.
#' @param MaxResults The number of items to return in the response.
#'
#' @keywords internal
#'
#' @rdname forecastservice_list_dataset_groups
forecastservice_list_dataset_groups <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDatasetGroups",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "DatasetGroups")
  )
  input <- .forecastservice$list_dataset_groups_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .forecastservice$list_dataset_groups_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$list_dataset_groups <- forecastservice_list_dataset_groups

#' Returns a list of dataset import jobs created using the
#' CreateDatasetImportJob operation
#'
#' @description
#' Returns a list of dataset import jobs created using the [`create_dataset_import_job`][forecastservice_create_dataset_import_job] operation. For each import job, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). You can retrieve the complete set of properties by using the ARN with the [`describe_dataset_import_job`][forecastservice_describe_dataset_import_job] operation. You can filter the list by providing an array of [Filter](https://docs.aws.amazon.com/forecast/latest/dg/API_Filter.html) objects.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_list_dataset_import_jobs/](https://www.paws-r-sdk.com/docs/forecastservice_list_dataset_import_jobs/) for full documentation.
#'
#' @param NextToken If the result of the previous request was truncated, the response
#' includes a `NextToken`. To retrieve the next set of results, use the
#' token in the next request. Tokens expire after 24 hours.
#' @param MaxResults The number of items to return in the response.
#' @param Filters An array of filters. For each filter, you provide a condition and a
#' match statement. The condition is either `IS` or `IS_NOT`, which
#' specifies whether to include or exclude the datasets that match the
#' statement from the list, respectively. The match statement consists of a
#' key and a value.
#' 
#' **Filter properties**
#' 
#' -   `Condition` - The condition to apply. Valid values are `IS` and
#'     `IS_NOT`. To include the datasets that match the statement, specify
#'     `IS`. To exclude matching datasets, specify `IS_NOT`.
#' 
#' -   `Key` - The name of the parameter to filter on. Valid values are
#'     `DatasetArn` and `Status`.
#' 
#' -   `Value` - The value to match.
#' 
#' For example, to list all dataset import jobs whose status is ACTIVE, you
#' specify the following filter:
#' 
#' `"Filters": [ { "Condition": "IS", "Key": "Status", "Value": "ACTIVE" } ]`
#'
#' @keywords internal
#'
#' @rdname forecastservice_list_dataset_import_jobs
forecastservice_list_dataset_import_jobs <- function(NextToken = NULL, MaxResults = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListDatasetImportJobs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "DatasetImportJobs")
  )
  input <- .forecastservice$list_dataset_import_jobs_input(NextToken = NextToken, MaxResults = MaxResults, Filters = Filters)
  output <- .forecastservice$list_dataset_import_jobs_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$list_dataset_import_jobs <- forecastservice_list_dataset_import_jobs

#' Returns a list of datasets created using the CreateDataset operation
#'
#' @description
#' Returns a list of datasets created using the [`create_dataset`][forecastservice_create_dataset] operation. For each dataset, a summary of its properties, including its Amazon Resource Name (ARN), is returned. To retrieve the complete set of properties, use the ARN with the [`describe_dataset`][forecastservice_describe_dataset] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_list_datasets/](https://www.paws-r-sdk.com/docs/forecastservice_list_datasets/) for full documentation.
#'
#' @param NextToken If the result of the previous request was truncated, the response
#' includes a `NextToken`. To retrieve the next set of results, use the
#' token in the next request. Tokens expire after 24 hours.
#' @param MaxResults The number of items to return in the response.
#'
#' @keywords internal
#'
#' @rdname forecastservice_list_datasets
forecastservice_list_datasets <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDatasets",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Datasets")
  )
  input <- .forecastservice$list_datasets_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .forecastservice$list_datasets_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$list_datasets <- forecastservice_list_datasets

#' Returns a list of Explainability resources created using the
#' CreateExplainability operation
#'
#' @description
#' Returns a list of Explainability resources created using the [`create_explainability`][forecastservice_create_explainability] operation. This operation returns a summary for each Explainability. You can filter the list using an array of Filter objects.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_list_explainabilities/](https://www.paws-r-sdk.com/docs/forecastservice_list_explainabilities/) for full documentation.
#'
#' @param NextToken If the result of the previous request was truncated, the response
#' includes a NextToken. To retrieve the next set of results, use the token
#' in the next request. Tokens expire after 24 hours.
#' @param MaxResults The number of items returned in the response.
#' @param Filters An array of filters. For each filter, provide a condition and a match
#' statement. The condition is either `IS` or `IS_NOT`, which specifies
#' whether to include or exclude the resources that match the statement
#' from the list. The match statement consists of a key and a value.
#' 
#' **Filter properties**
#' 
#' -   `Condition` - The condition to apply. Valid values are `IS` and
#'     `IS_NOT`.
#' 
#' -   `Key` - The name of the parameter to filter on. Valid values are
#'     `ResourceArn` and `Status`.
#' 
#' -   `Value` - The value to match.
#'
#' @keywords internal
#'
#' @rdname forecastservice_list_explainabilities
forecastservice_list_explainabilities <- function(NextToken = NULL, MaxResults = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListExplainabilities",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Explainabilities")
  )
  input <- .forecastservice$list_explainabilities_input(NextToken = NextToken, MaxResults = MaxResults, Filters = Filters)
  output <- .forecastservice$list_explainabilities_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$list_explainabilities <- forecastservice_list_explainabilities

#' Returns a list of Explainability exports created using the
#' CreateExplainabilityExport operation
#'
#' @description
#' Returns a list of Explainability exports created using the [`create_explainability_export`][forecastservice_create_explainability_export] operation. This operation returns a summary for each Explainability export. You can filter the list using an array of Filter objects.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_list_explainability_exports/](https://www.paws-r-sdk.com/docs/forecastservice_list_explainability_exports/) for full documentation.
#'
#' @param NextToken If the result of the previous request was truncated, the response
#' includes a NextToken. To retrieve the next set of results, use the token
#' in the next request. Tokens expire after 24 hours.
#' @param MaxResults The number of items to return in the response.
#' @param Filters An array of filters. For each filter, provide a condition and a match
#' statement. The condition is either `IS` or `IS_NOT`, which specifies
#' whether to include or exclude resources that match the statement from
#' the list. The match statement consists of a key and a value.
#' 
#' **Filter properties**
#' 
#' -   `Condition` - The condition to apply. Valid values are `IS` and
#'     `IS_NOT`.
#' 
#' -   `Key` - The name of the parameter to filter on. Valid values are
#'     `ResourceArn` and `Status`.
#' 
#' -   `Value` - The value to match.
#'
#' @keywords internal
#'
#' @rdname forecastservice_list_explainability_exports
forecastservice_list_explainability_exports <- function(NextToken = NULL, MaxResults = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListExplainabilityExports",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ExplainabilityExports")
  )
  input <- .forecastservice$list_explainability_exports_input(NextToken = NextToken, MaxResults = MaxResults, Filters = Filters)
  output <- .forecastservice$list_explainability_exports_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$list_explainability_exports <- forecastservice_list_explainability_exports

#' Returns a list of forecast export jobs created using the
#' CreateForecastExportJob operation
#'
#' @description
#' Returns a list of forecast export jobs created using the [`create_forecast_export_job`][forecastservice_create_forecast_export_job] operation. For each forecast export job, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). To retrieve the complete set of properties, use the ARN with the [`describe_forecast_export_job`][forecastservice_describe_forecast_export_job] operation. You can filter the list using an array of Filter objects.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_list_forecast_export_jobs/](https://www.paws-r-sdk.com/docs/forecastservice_list_forecast_export_jobs/) for full documentation.
#'
#' @param NextToken If the result of the previous request was truncated, the response
#' includes a `NextToken`. To retrieve the next set of results, use the
#' token in the next request. Tokens expire after 24 hours.
#' @param MaxResults The number of items to return in the response.
#' @param Filters An array of filters. For each filter, you provide a condition and a
#' match statement. The condition is either `IS` or `IS_NOT`, which
#' specifies whether to include or exclude the forecast export jobs that
#' match the statement from the list, respectively. The match statement
#' consists of a key and a value.
#' 
#' **Filter properties**
#' 
#' -   `Condition` - The condition to apply. Valid values are `IS` and
#'     `IS_NOT`. To include the forecast export jobs that match the
#'     statement, specify `IS`. To exclude matching forecast export jobs,
#'     specify `IS_NOT`.
#' 
#' -   `Key` - The name of the parameter to filter on. Valid values are
#'     `ForecastArn` and `Status`.
#' 
#' -   `Value` - The value to match.
#' 
#' For example, to list all jobs that export a forecast named
#' *electricityforecast*, specify the following filter:
#' 
#' `"Filters": [ { "Condition": "IS", "Key": "ForecastArn", "Value": "arn:aws:forecast:us-west-2:<acct-id>:forecast/electricityforecast" } ]`
#'
#' @keywords internal
#'
#' @rdname forecastservice_list_forecast_export_jobs
forecastservice_list_forecast_export_jobs <- function(NextToken = NULL, MaxResults = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListForecastExportJobs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ForecastExportJobs")
  )
  input <- .forecastservice$list_forecast_export_jobs_input(NextToken = NextToken, MaxResults = MaxResults, Filters = Filters)
  output <- .forecastservice$list_forecast_export_jobs_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$list_forecast_export_jobs <- forecastservice_list_forecast_export_jobs

#' Returns a list of forecasts created using the CreateForecast operation
#'
#' @description
#' Returns a list of forecasts created using the [`create_forecast`][forecastservice_create_forecast] operation. For each forecast, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). To retrieve the complete set of properties, specify the ARN with the [`describe_forecast`][forecastservice_describe_forecast] operation. You can filter the list using an array of Filter objects.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_list_forecasts/](https://www.paws-r-sdk.com/docs/forecastservice_list_forecasts/) for full documentation.
#'
#' @param NextToken If the result of the previous request was truncated, the response
#' includes a `NextToken`. To retrieve the next set of results, use the
#' token in the next request. Tokens expire after 24 hours.
#' @param MaxResults The number of items to return in the response.
#' @param Filters An array of filters. For each filter, you provide a condition and a
#' match statement. The condition is either `IS` or `IS_NOT`, which
#' specifies whether to include or exclude the forecasts that match the
#' statement from the list, respectively. The match statement consists of a
#' key and a value.
#' 
#' **Filter properties**
#' 
#' -   `Condition` - The condition to apply. Valid values are `IS` and
#'     `IS_NOT`. To include the forecasts that match the statement, specify
#'     `IS`. To exclude matching forecasts, specify `IS_NOT`.
#' 
#' -   `Key` - The name of the parameter to filter on. Valid values are
#'     `DatasetGroupArn`, `PredictorArn`, and `Status`.
#' 
#' -   `Value` - The value to match.
#' 
#' For example, to list all forecasts whose status is not ACTIVE, you would
#' specify:
#' 
#' `"Filters": [ { "Condition": "IS_NOT", "Key": "Status", "Value": "ACTIVE" } ]`
#'
#' @keywords internal
#'
#' @rdname forecastservice_list_forecasts
forecastservice_list_forecasts <- function(NextToken = NULL, MaxResults = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListForecasts",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Forecasts")
  )
  input <- .forecastservice$list_forecasts_input(NextToken = NextToken, MaxResults = MaxResults, Filters = Filters)
  output <- .forecastservice$list_forecasts_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$list_forecasts <- forecastservice_list_forecasts

#' Returns a list of the monitoring evaluation results and predictor events
#' collected by the monitor resource during different windows of time
#'
#' @description
#' Returns a list of the monitoring evaluation results and predictor events collected by the monitor resource during different windows of time.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_list_monitor_evaluations/](https://www.paws-r-sdk.com/docs/forecastservice_list_monitor_evaluations/) for full documentation.
#'
#' @param NextToken If the result of the previous request was truncated, the response
#' includes a `NextToken`. To retrieve the next set of results, use the
#' token in the next request. Tokens expire after 24 hours.
#' @param MaxResults The maximum number of monitoring results to return.
#' @param MonitorArn &#91;required&#93; The Amazon Resource Name (ARN) of the monitor resource to get results
#' from.
#' @param Filters An array of filters. For each filter, provide a condition and a match
#' statement. The condition is either `IS` or `IS_NOT`, which specifies
#' whether to include or exclude the resources that match the statement
#' from the list. The match statement consists of a key and a value.
#' 
#' **Filter properties**
#' 
#' -   `Condition` - The condition to apply. Valid values are `IS` and
#'     `IS_NOT`.
#' 
#' -   `Key` - The name of the parameter to filter on. The only valid value
#'     is `EvaluationState`.
#' 
#' -   `Value` - The value to match. Valid values are only `SUCCESS` or
#'     `FAILURE`.
#' 
#' For example, to list only successful monitor evaluations, you would
#' specify:
#' 
#' `"Filters": [ { "Condition": "IS", "Key": "EvaluationState", "Value": "SUCCESS" } ]`
#'
#' @keywords internal
#'
#' @rdname forecastservice_list_monitor_evaluations
forecastservice_list_monitor_evaluations <- function(NextToken = NULL, MaxResults = NULL, MonitorArn, Filters = NULL) {
  op <- new_operation(
    name = "ListMonitorEvaluations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "PredictorMonitorEvaluations")
  )
  input <- .forecastservice$list_monitor_evaluations_input(NextToken = NextToken, MaxResults = MaxResults, MonitorArn = MonitorArn, Filters = Filters)
  output <- .forecastservice$list_monitor_evaluations_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$list_monitor_evaluations <- forecastservice_list_monitor_evaluations

#' Returns a list of monitors created with the CreateMonitor operation and
#' CreateAutoPredictor operation
#'
#' @description
#' Returns a list of monitors created with the [`create_monitor`][forecastservice_create_monitor] operation and [`create_auto_predictor`][forecastservice_create_auto_predictor] operation. For each monitor resource, this operation returns of a summary of its properties, including its Amazon Resource Name (ARN). You can retrieve a complete set of properties of a monitor resource by specify the monitor's ARN in the [`describe_monitor`][forecastservice_describe_monitor] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_list_monitors/](https://www.paws-r-sdk.com/docs/forecastservice_list_monitors/) for full documentation.
#'
#' @param NextToken If the result of the previous request was truncated, the response
#' includes a `NextToken`. To retrieve the next set of results, use the
#' token in the next request. Tokens expire after 24 hours.
#' @param MaxResults The maximum number of monitors to include in the response.
#' @param Filters An array of filters. For each filter, provide a condition and a match
#' statement. The condition is either `IS` or `IS_NOT`, which specifies
#' whether to include or exclude the resources that match the statement
#' from the list. The match statement consists of a key and a value.
#' 
#' **Filter properties**
#' 
#' -   `Condition` - The condition to apply. Valid values are `IS` and
#'     `IS_NOT`.
#' 
#' -   `Key` - The name of the parameter to filter on. The only valid value
#'     is `Status`.
#' 
#' -   `Value` - The value to match.
#' 
#' For example, to list all monitors who's status is ACTIVE, you would
#' specify:
#' 
#' `"Filters": [ { "Condition": "IS", "Key": "Status", "Value": "ACTIVE" } ]`
#'
#' @keywords internal
#'
#' @rdname forecastservice_list_monitors
forecastservice_list_monitors <- function(NextToken = NULL, MaxResults = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListMonitors",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Monitors")
  )
  input <- .forecastservice$list_monitors_input(NextToken = NextToken, MaxResults = MaxResults, Filters = Filters)
  output <- .forecastservice$list_monitors_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$list_monitors <- forecastservice_list_monitors

#' Returns a list of predictor backtest export jobs created using the
#' CreatePredictorBacktestExportJob operation
#'
#' @description
#' Returns a list of predictor backtest export jobs created using the [`create_predictor_backtest_export_job`][forecastservice_create_predictor_backtest_export_job] operation. This operation returns a summary for each backtest export job. You can filter the list using an array of Filter objects.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_list_predictor_backtest_export_jobs/](https://www.paws-r-sdk.com/docs/forecastservice_list_predictor_backtest_export_jobs/) for full documentation.
#'
#' @param NextToken If the result of the previous request was truncated, the response
#' includes a NextToken. To retrieve the next set of results, use the token
#' in the next request. Tokens expire after 24 hours.
#' @param MaxResults The number of items to return in the response.
#' @param Filters An array of filters. For each filter, provide a condition and a match
#' statement. The condition is either `IS` or `IS_NOT`, which specifies
#' whether to include or exclude the predictor backtest export jobs that
#' match the statement from the list. The match statement consists of a key
#' and a value.
#' 
#' **Filter properties**
#' 
#' -   `Condition` - The condition to apply. Valid values are `IS` and
#'     `IS_NOT`. To include the predictor backtest export jobs that match
#'     the statement, specify `IS`. To exclude matching predictor backtest
#'     export jobs, specify `IS_NOT`.
#' 
#' -   `Key` - The name of the parameter to filter on. Valid values are
#'     `PredictorArn` and `Status`.
#' 
#' -   `Value` - The value to match.
#'
#' @keywords internal
#'
#' @rdname forecastservice_list_predictor_backtest_export_jobs
forecastservice_list_predictor_backtest_export_jobs <- function(NextToken = NULL, MaxResults = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListPredictorBacktestExportJobs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "PredictorBacktestExportJobs")
  )
  input <- .forecastservice$list_predictor_backtest_export_jobs_input(NextToken = NextToken, MaxResults = MaxResults, Filters = Filters)
  output <- .forecastservice$list_predictor_backtest_export_jobs_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$list_predictor_backtest_export_jobs <- forecastservice_list_predictor_backtest_export_jobs

#' Returns a list of predictors created using the CreateAutoPredictor or
#' CreatePredictor operations
#'
#' @description
#' Returns a list of predictors created using the [`create_auto_predictor`][forecastservice_create_auto_predictor] or [`create_predictor`][forecastservice_create_predictor] operations. For each predictor, this operation returns a summary of its properties, including its Amazon Resource Name (ARN).
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_list_predictors/](https://www.paws-r-sdk.com/docs/forecastservice_list_predictors/) for full documentation.
#'
#' @param NextToken If the result of the previous request was truncated, the response
#' includes a `NextToken`. To retrieve the next set of results, use the
#' token in the next request. Tokens expire after 24 hours.
#' @param MaxResults The number of items to return in the response.
#' @param Filters An array of filters. For each filter, you provide a condition and a
#' match statement. The condition is either `IS` or `IS_NOT`, which
#' specifies whether to include or exclude the predictors that match the
#' statement from the list, respectively. The match statement consists of a
#' key and a value.
#' 
#' **Filter properties**
#' 
#' -   `Condition` - The condition to apply. Valid values are `IS` and
#'     `IS_NOT`. To include the predictors that match the statement,
#'     specify `IS`. To exclude matching predictors, specify `IS_NOT`.
#' 
#' -   `Key` - The name of the parameter to filter on. Valid values are
#'     `DatasetGroupArn` and `Status`.
#' 
#' -   `Value` - The value to match.
#' 
#' For example, to list all predictors whose status is ACTIVE, you would
#' specify:
#' 
#' `"Filters": [ { "Condition": "IS", "Key": "Status", "Value": "ACTIVE" } ]`
#'
#' @keywords internal
#'
#' @rdname forecastservice_list_predictors
forecastservice_list_predictors <- function(NextToken = NULL, MaxResults = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListPredictors",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Predictors")
  )
  input <- .forecastservice$list_predictors_input(NextToken = NextToken, MaxResults = MaxResults, Filters = Filters)
  output <- .forecastservice$list_predictors_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$list_predictors <- forecastservice_list_predictors

#' Lists the tags for an Amazon Forecast resource
#'
#' @description
#' Lists the tags for an Amazon Forecast resource.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/forecastservice_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the resource for which to
#' list the tags.
#'
#' @keywords internal
#'
#' @rdname forecastservice_list_tags_for_resource
forecastservice_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .forecastservice$list_tags_for_resource_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$list_tags_for_resource <- forecastservice_list_tags_for_resource

#' Returns a list of what-if analyses created using the
#' CreateWhatIfAnalysis operation
#'
#' @description
#' Returns a list of what-if analyses created using the [`create_what_if_analysis`][forecastservice_create_what_if_analysis] operation. For each what-if analysis, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). You can retrieve the complete set of properties by using the what-if analysis ARN with the [`describe_what_if_analysis`][forecastservice_describe_what_if_analysis] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_list_what_if_analyses/](https://www.paws-r-sdk.com/docs/forecastservice_list_what_if_analyses/) for full documentation.
#'
#' @param NextToken If the result of the previous request was truncated, the response
#' includes a `NextToken`. To retrieve the next set of results, use the
#' token in the next request. Tokens expire after 24 hours.
#' @param MaxResults The number of items to return in the response.
#' @param Filters An array of filters. For each filter, you provide a condition and a
#' match statement. The condition is either `IS` or `IS_NOT`, which
#' specifies whether to include or exclude the what-if analysis jobs that
#' match the statement from the list, respectively. The match statement
#' consists of a key and a value.
#' 
#' **Filter properties**
#' 
#' -   `Condition` - The condition to apply. Valid values are `IS` and
#'     `IS_NOT`. To include the what-if analysis jobs that match the
#'     statement, specify `IS`. To exclude matching what-if analysis jobs,
#'     specify `IS_NOT`.
#' 
#' -   `Key` - The name of the parameter to filter on. Valid values are
#'     `WhatIfAnalysisArn` and `Status`.
#' 
#' -   `Value` - The value to match.
#' 
#' For example, to list all jobs that export a forecast named
#' *electricityWhatIf*, specify the following filter:
#' 
#' `"Filters": [ { "Condition": "IS", "Key": "WhatIfAnalysisArn", "Value": "arn:aws:forecast:us-west-2:<acct-id>:forecast/electricityWhatIf" } ]`
#'
#' @keywords internal
#'
#' @rdname forecastservice_list_what_if_analyses
forecastservice_list_what_if_analyses <- function(NextToken = NULL, MaxResults = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListWhatIfAnalyses",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "WhatIfAnalyses")
  )
  input <- .forecastservice$list_what_if_analyses_input(NextToken = NextToken, MaxResults = MaxResults, Filters = Filters)
  output <- .forecastservice$list_what_if_analyses_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$list_what_if_analyses <- forecastservice_list_what_if_analyses

#' Returns a list of what-if forecast exports created using the
#' CreateWhatIfForecastExport operation
#'
#' @description
#' Returns a list of what-if forecast exports created using the [`create_what_if_forecast_export`][forecastservice_create_what_if_forecast_export] operation. For each what-if forecast export, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). You can retrieve the complete set of properties by using the what-if forecast export ARN with the [`describe_what_if_forecast_export`][forecastservice_describe_what_if_forecast_export] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_list_what_if_forecast_exports/](https://www.paws-r-sdk.com/docs/forecastservice_list_what_if_forecast_exports/) for full documentation.
#'
#' @param NextToken If the result of the previous request was truncated, the response
#' includes a `NextToken`. To retrieve the next set of results, use the
#' token in the next request. Tokens expire after 24 hours.
#' @param MaxResults The number of items to return in the response.
#' @param Filters An array of filters. For each filter, you provide a condition and a
#' match statement. The condition is either `IS` or `IS_NOT`, which
#' specifies whether to include or exclude the what-if forecast export jobs
#' that match the statement from the list, respectively. The match
#' statement consists of a key and a value.
#' 
#' **Filter properties**
#' 
#' -   `Condition` - The condition to apply. Valid values are `IS` and
#'     `IS_NOT`. To include the forecast export jobs that match the
#'     statement, specify `IS`. To exclude matching forecast export jobs,
#'     specify `IS_NOT`.
#' 
#' -   `Key` - The name of the parameter to filter on. Valid values are
#'     `WhatIfForecastExportArn` and `Status`.
#' 
#' -   `Value` - The value to match.
#' 
#' For example, to list all jobs that export a forecast named
#' *electricityWIFExport*, specify the following filter:
#' 
#' `"Filters": [ { "Condition": "IS", "Key": "WhatIfForecastExportArn", "Value": "arn:aws:forecast:us-west-2:<acct-id>:forecast/electricityWIFExport" } ]`
#'
#' @keywords internal
#'
#' @rdname forecastservice_list_what_if_forecast_exports
forecastservice_list_what_if_forecast_exports <- function(NextToken = NULL, MaxResults = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListWhatIfForecastExports",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "WhatIfForecastExports")
  )
  input <- .forecastservice$list_what_if_forecast_exports_input(NextToken = NextToken, MaxResults = MaxResults, Filters = Filters)
  output <- .forecastservice$list_what_if_forecast_exports_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$list_what_if_forecast_exports <- forecastservice_list_what_if_forecast_exports

#' Returns a list of what-if forecasts created using the
#' CreateWhatIfForecast operation
#'
#' @description
#' Returns a list of what-if forecasts created using the [`create_what_if_forecast`][forecastservice_create_what_if_forecast] operation. For each what-if forecast, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). You can retrieve the complete set of properties by using the what-if forecast ARN with the [`describe_what_if_forecast`][forecastservice_describe_what_if_forecast] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_list_what_if_forecasts/](https://www.paws-r-sdk.com/docs/forecastservice_list_what_if_forecasts/) for full documentation.
#'
#' @param NextToken If the result of the previous request was truncated, the response
#' includes a `NextToken`. To retrieve the next set of results, use the
#' token in the next request. Tokens expire after 24 hours.
#' @param MaxResults The number of items to return in the response.
#' @param Filters An array of filters. For each filter, you provide a condition and a
#' match statement. The condition is either `IS` or `IS_NOT`, which
#' specifies whether to include or exclude the what-if forecast export jobs
#' that match the statement from the list, respectively. The match
#' statement consists of a key and a value.
#' 
#' **Filter properties**
#' 
#' -   `Condition` - The condition to apply. Valid values are `IS` and
#'     `IS_NOT`. To include the forecast export jobs that match the
#'     statement, specify `IS`. To exclude matching forecast export jobs,
#'     specify `IS_NOT`.
#' 
#' -   `Key` - The name of the parameter to filter on. Valid values are
#'     `WhatIfForecastArn` and `Status`.
#' 
#' -   `Value` - The value to match.
#' 
#' For example, to list all jobs that export a forecast named
#' *electricityWhatIfForecast*, specify the following filter:
#' 
#' `"Filters": [ { "Condition": "IS", "Key": "WhatIfForecastArn", "Value": "arn:aws:forecast:us-west-2:<acct-id>:forecast/electricityWhatIfForecast" } ]`
#'
#' @keywords internal
#'
#' @rdname forecastservice_list_what_if_forecasts
forecastservice_list_what_if_forecasts <- function(NextToken = NULL, MaxResults = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListWhatIfForecasts",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "WhatIfForecasts")
  )
  input <- .forecastservice$list_what_if_forecasts_input(NextToken = NextToken, MaxResults = MaxResults, Filters = Filters)
  output <- .forecastservice$list_what_if_forecasts_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$list_what_if_forecasts <- forecastservice_list_what_if_forecasts

#' Resumes a stopped monitor resource
#'
#' @description
#' Resumes a stopped monitor resource.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_resume_resource/](https://www.paws-r-sdk.com/docs/forecastservice_resume_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the monitor resource to resume.
#'
#' @keywords internal
#'
#' @rdname forecastservice_resume_resource
forecastservice_resume_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ResumeResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$resume_resource_input(ResourceArn = ResourceArn)
  output <- .forecastservice$resume_resource_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$resume_resource <- forecastservice_resume_resource

#' Stops a resource
#'
#' @description
#' Stops a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_stop_resource/](https://www.paws-r-sdk.com/docs/forecastservice_stop_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the resource to stop. The
#' supported ARNs are `DatasetImportJobArn`, `PredictorArn`,
#' `PredictorBacktestExportJobArn`, `ForecastArn`, `ForecastExportJobArn`,
#' `ExplainabilityArn`, and `ExplainabilityExportArn`.
#'
#' @keywords internal
#'
#' @rdname forecastservice_stop_resource
forecastservice_stop_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "StopResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$stop_resource_input(ResourceArn = ResourceArn)
  output <- .forecastservice$stop_resource_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$stop_resource <- forecastservice_stop_resource

#' Associates the specified tags to a resource with the specified
#' resourceArn
#'
#' @description
#' Associates the specified tags to a resource with the specified `resourceArn`. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are also deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_tag_resource/](https://www.paws-r-sdk.com/docs/forecastservice_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the resource for which to
#' list the tags.
#' @param Tags &#91;required&#93; The tags to add to the resource. A tag is an array of key-value pairs.
#' 
#' The following basic restrictions apply to tags:
#' 
#' -   Maximum number of tags per resource - 50.
#' 
#' -   For each resource, each tag key must be unique, and each tag key can
#'     have only one value.
#' 
#' -   Maximum key length - 128 Unicode characters in UTF-8.
#' 
#' -   Maximum value length - 256 Unicode characters in UTF-8.
#' 
#' -   If your tagging schema is used across multiple services and
#'     resources, remember that other services may have restrictions on
#'     allowed characters. Generally allowed characters are: letters,
#'     numbers, and spaces representable in UTF-8, and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Tag keys and values are case sensitive.
#' 
#' -   Do not use `aws:`, `AWS:`, or any upper or lowercase combination of
#'     such as a prefix for keys as it is reserved for Amazon Web Services
#'     use. You cannot edit or delete tag keys with this prefix. Values can
#'     have this prefix. If a tag value has `aws` as its prefix but the key
#'     does not, then Forecast considers it to be a user tag and will count
#'     against the limit of 50 tags. Tags with only the key prefix of `aws`
#'     do not count against your tags per resource limit.
#'
#' @keywords internal
#'
#' @rdname forecastservice_tag_resource
forecastservice_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .forecastservice$tag_resource_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$tag_resource <- forecastservice_tag_resource

#' Deletes the specified tags from a resource
#'
#' @description
#' Deletes the specified tags from a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_untag_resource/](https://www.paws-r-sdk.com/docs/forecastservice_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the resource for which to
#' list the tags.
#' @param TagKeys &#91;required&#93; The keys of the tags to be removed.
#'
#' @keywords internal
#'
#' @rdname forecastservice_untag_resource
forecastservice_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .forecastservice$untag_resource_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$untag_resource <- forecastservice_untag_resource

#' Replaces the datasets in a dataset group with the specified datasets
#'
#' @description
#' Replaces the datasets in a dataset group with the specified datasets.
#'
#' See [https://www.paws-r-sdk.com/docs/forecastservice_update_dataset_group/](https://www.paws-r-sdk.com/docs/forecastservice_update_dataset_group/) for full documentation.
#'
#' @param DatasetGroupArn &#91;required&#93; The ARN of the dataset group.
#' @param DatasetArns &#91;required&#93; An array of the Amazon Resource Names (ARNs) of the datasets to add to
#' the dataset group.
#'
#' @keywords internal
#'
#' @rdname forecastservice_update_dataset_group
forecastservice_update_dataset_group <- function(DatasetGroupArn, DatasetArns) {
  op <- new_operation(
    name = "UpdateDatasetGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .forecastservice$update_dataset_group_input(DatasetGroupArn = DatasetGroupArn, DatasetArns = DatasetArns)
  output <- .forecastservice$update_dataset_group_output()
  config <- get_config()
  svc <- .forecastservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.forecastservice$operations$update_dataset_group <- forecastservice_update_dataset_group
