% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelsv2_operations.R
\name{lexmodelsv2_list_intent_paths}
\alias{lexmodelsv2_list_intent_paths}
\title{Retrieves summary statistics for a path of intents that users take over
sessions with your bot}
\usage{
lexmodelsv2_list_intent_paths(
  botId,
  startDateTime,
  endDateTime,
  intentPath,
  filters = NULL
)
}
\arguments{
\item{botId}{[required] The identifier for the bot for which you want to retrieve intent path
metrics.}

\item{startDateTime}{[required] The date and time that marks the beginning of the range of time for
which you want to see intent path metrics.}

\item{endDateTime}{[required] The date and time that marks the end of the range of time for which you
want to see intent path metrics.}

\item{intentPath}{[required] The intent path for which you want to retrieve metrics. Use a forward
slash to separate intents in the path. For example:
\itemize{
\item /BookCar
\item /BookCar/BookHotel
\item /BookHotel/BookCar
}}

\item{filters}{A list of objects, each describes a condition by which you want to
filter the results.}
}
\description{
Retrieves summary statistics for a path of intents that users take over sessions with your bot. The following fields are required:

See \url{https://www.paws-r-sdk.com/docs/lexmodelsv2_list_intent_paths/} for full documentation.
}
\keyword{internal}
