# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon Forecast Service
#'
#' @description
#' Provides APIs for creating and managing Amazon Forecast resources.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- forecastservice(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- forecastservice()
#' svc$create_auto_predictor(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=forecastservice_create_auto_predictor]{create_auto_predictor} \tab Creates an Amazon Forecast predictor\cr
#'  \link[=forecastservice_create_dataset]{create_dataset} \tab Creates an Amazon Forecast dataset\cr
#'  \link[=forecastservice_create_dataset_group]{create_dataset_group} \tab Creates a dataset group, which holds a collection of related datasets\cr
#'  \link[=forecastservice_create_dataset_import_job]{create_dataset_import_job} \tab Imports your training data to an Amazon Forecast dataset\cr
#'  \link[=forecastservice_create_explainability]{create_explainability} \tab Explainability is only available for Forecasts and Predictors generated from an AutoPredictor (CreateAutoPredictor)\cr
#'  \link[=forecastservice_create_explainability_export]{create_explainability_export} \tab Exports an Explainability resource created by the CreateExplainability operation\cr
#'  \link[=forecastservice_create_forecast]{create_forecast} \tab Creates a forecast for each item in the TARGET_TIME_SERIES dataset that was used to train the predictor\cr
#'  \link[=forecastservice_create_forecast_export_job]{create_forecast_export_job} \tab Exports a forecast created by the CreateForecast operation to your Amazon Simple Storage Service (Amazon S3) bucket\cr
#'  \link[=forecastservice_create_monitor]{create_monitor} \tab Creates a predictor monitor resource for an existing auto predictor\cr
#'  \link[=forecastservice_create_predictor]{create_predictor} \tab This operation creates a legacy predictor that does not include all the predictor functionalities provided by Amazon Forecast\cr
#'  \link[=forecastservice_create_predictor_backtest_export_job]{create_predictor_backtest_export_job} \tab Exports backtest forecasts and accuracy metrics generated by the CreateAutoPredictor or CreatePredictor operations\cr
#'  \link[=forecastservice_create_what_if_analysis]{create_what_if_analysis} \tab What-if analysis is a scenario modeling technique where you make a hypothetical change to a time series and compare the forecasts generated by these changes against the baseline, unchanged time series\cr
#'  \link[=forecastservice_create_what_if_forecast]{create_what_if_forecast} \tab A what-if forecast is a forecast that is created from a modified version of the baseline forecast\cr
#'  \link[=forecastservice_create_what_if_forecast_export]{create_what_if_forecast_export} \tab Exports a forecast created by the CreateWhatIfForecast operation to your Amazon Simple Storage Service (Amazon S3) bucket\cr
#'  \link[=forecastservice_delete_dataset]{delete_dataset} \tab Deletes an Amazon Forecast dataset that was created using the CreateDataset operation\cr
#'  \link[=forecastservice_delete_dataset_group]{delete_dataset_group} \tab Deletes a dataset group created using the CreateDatasetGroup operation\cr
#'  \link[=forecastservice_delete_dataset_import_job]{delete_dataset_import_job} \tab Deletes a dataset import job created using the CreateDatasetImportJob operation\cr
#'  \link[=forecastservice_delete_explainability]{delete_explainability} \tab Deletes an Explainability resource\cr
#'  \link[=forecastservice_delete_explainability_export]{delete_explainability_export} \tab Deletes an Explainability export\cr
#'  \link[=forecastservice_delete_forecast]{delete_forecast} \tab Deletes a forecast created using the CreateForecast operation\cr
#'  \link[=forecastservice_delete_forecast_export_job]{delete_forecast_export_job} \tab Deletes a forecast export job created using the CreateForecastExportJob operation\cr
#'  \link[=forecastservice_delete_monitor]{delete_monitor} \tab Deletes a monitor resource\cr
#'  \link[=forecastservice_delete_predictor]{delete_predictor} \tab Deletes a predictor created using the DescribePredictor or CreatePredictor operations\cr
#'  \link[=forecastservice_delete_predictor_backtest_export_job]{delete_predictor_backtest_export_job} \tab Deletes a predictor backtest export job\cr
#'  \link[=forecastservice_delete_resource_tree]{delete_resource_tree} \tab Deletes an entire resource tree\cr
#'  \link[=forecastservice_delete_what_if_analysis]{delete_what_if_analysis} \tab Deletes a what-if analysis created using the CreateWhatIfAnalysis operation\cr
#'  \link[=forecastservice_delete_what_if_forecast]{delete_what_if_forecast} \tab Deletes a what-if forecast created using the CreateWhatIfForecast operation\cr
#'  \link[=forecastservice_delete_what_if_forecast_export]{delete_what_if_forecast_export} \tab Deletes a what-if forecast export created using the CreateWhatIfForecastExport operation\cr
#'  \link[=forecastservice_describe_auto_predictor]{describe_auto_predictor} \tab Describes a predictor created using the CreateAutoPredictor operation\cr
#'  \link[=forecastservice_describe_dataset]{describe_dataset} \tab Describes an Amazon Forecast dataset created using the CreateDataset operation\cr
#'  \link[=forecastservice_describe_dataset_group]{describe_dataset_group} \tab Describes a dataset group created using the CreateDatasetGroup operation\cr
#'  \link[=forecastservice_describe_dataset_import_job]{describe_dataset_import_job} \tab Describes a dataset import job created using the CreateDatasetImportJob operation\cr
#'  \link[=forecastservice_describe_explainability]{describe_explainability} \tab Describes an Explainability resource created using the CreateExplainability operation\cr
#'  \link[=forecastservice_describe_explainability_export]{describe_explainability_export} \tab Describes an Explainability export created using the CreateExplainabilityExport operation\cr
#'  \link[=forecastservice_describe_forecast]{describe_forecast} \tab Describes a forecast created using the CreateForecast operation\cr
#'  \link[=forecastservice_describe_forecast_export_job]{describe_forecast_export_job} \tab Describes a forecast export job created using the CreateForecastExportJob operation\cr
#'  \link[=forecastservice_describe_monitor]{describe_monitor} \tab Describes a monitor resource\cr
#'  \link[=forecastservice_describe_predictor]{describe_predictor} \tab This operation is only valid for legacy predictors created with CreatePredictor\cr
#'  \link[=forecastservice_describe_predictor_backtest_export_job]{describe_predictor_backtest_export_job} \tab Describes a predictor backtest export job created using the CreatePredictorBacktestExportJob operation\cr
#'  \link[=forecastservice_describe_what_if_analysis]{describe_what_if_analysis} \tab Describes the what-if analysis created using the CreateWhatIfAnalysis operation\cr
#'  \link[=forecastservice_describe_what_if_forecast]{describe_what_if_forecast} \tab Describes the what-if forecast created using the CreateWhatIfForecast operation\cr
#'  \link[=forecastservice_describe_what_if_forecast_export]{describe_what_if_forecast_export} \tab Describes the what-if forecast export created using the CreateWhatIfForecastExport operation\cr
#'  \link[=forecastservice_get_accuracy_metrics]{get_accuracy_metrics} \tab Provides metrics on the accuracy of the models that were trained by the CreatePredictor operation\cr
#'  \link[=forecastservice_list_dataset_groups]{list_dataset_groups} \tab Returns a list of dataset groups created using the CreateDatasetGroup operation\cr
#'  \link[=forecastservice_list_dataset_import_jobs]{list_dataset_import_jobs} \tab Returns a list of dataset import jobs created using the CreateDatasetImportJob operation\cr
#'  \link[=forecastservice_list_datasets]{list_datasets} \tab Returns a list of datasets created using the CreateDataset operation\cr
#'  \link[=forecastservice_list_explainabilities]{list_explainabilities} \tab Returns a list of Explainability resources created using the CreateExplainability operation\cr
#'  \link[=forecastservice_list_explainability_exports]{list_explainability_exports} \tab Returns a list of Explainability exports created using the CreateExplainabilityExport operation\cr
#'  \link[=forecastservice_list_forecast_export_jobs]{list_forecast_export_jobs} \tab Returns a list of forecast export jobs created using the CreateForecastExportJob operation\cr
#'  \link[=forecastservice_list_forecasts]{list_forecasts} \tab Returns a list of forecasts created using the CreateForecast operation\cr
#'  \link[=forecastservice_list_monitor_evaluations]{list_monitor_evaluations} \tab Returns a list of the monitoring evaluation results and predictor events collected by the monitor resource during different windows of time\cr
#'  \link[=forecastservice_list_monitors]{list_monitors} \tab Returns a list of monitors created with the CreateMonitor operation and CreateAutoPredictor operation\cr
#'  \link[=forecastservice_list_predictor_backtest_export_jobs]{list_predictor_backtest_export_jobs} \tab Returns a list of predictor backtest export jobs created using the CreatePredictorBacktestExportJob operation\cr
#'  \link[=forecastservice_list_predictors]{list_predictors} \tab Returns a list of predictors created using the CreateAutoPredictor or CreatePredictor operations\cr
#'  \link[=forecastservice_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags for an Amazon Forecast resource\cr
#'  \link[=forecastservice_list_what_if_analyses]{list_what_if_analyses} \tab Returns a list of what-if analyses created using the CreateWhatIfAnalysis operation\cr
#'  \link[=forecastservice_list_what_if_forecast_exports]{list_what_if_forecast_exports} \tab Returns a list of what-if forecast exports created using the CreateWhatIfForecastExport operation\cr
#'  \link[=forecastservice_list_what_if_forecasts]{list_what_if_forecasts} \tab Returns a list of what-if forecasts created using the CreateWhatIfForecast operation\cr
#'  \link[=forecastservice_resume_resource]{resume_resource} \tab Resumes a stopped monitor resource\cr
#'  \link[=forecastservice_stop_resource]{stop_resource} \tab Stops a resource\cr
#'  \link[=forecastservice_tag_resource]{tag_resource} \tab Associates the specified tags to a resource with the specified resourceArn\cr
#'  \link[=forecastservice_untag_resource]{untag_resource} \tab Deletes the specified tags from a resource\cr
#'  \link[=forecastservice_update_dataset_group]{update_dataset_group} \tab Replaces the datasets in a dataset group with the specified datasets
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname forecastservice
#' @export
forecastservice <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .forecastservice$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.forecastservice <- list()

.forecastservice$operations <- list()

.forecastservice$metadata <- list(
  service_name = "forecastservice",
  endpoints = list("*" = list(endpoint = "forecast.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "forecast.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "forecast.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "forecast.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "forecast.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "forecast.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "forecast",
  api_version = "2018-06-26",
  signing_name = "forecast",
  json_version = "1.1",
  target_prefix = "AmazonForecast"
)

.forecastservice$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.forecastservice$metadata, handlers, config)
}
