% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_compilation_jobs}
\alias{sagemaker_list_compilation_jobs}
\title{Lists model compilation jobs that satisfy various filters}
\usage{
sagemaker_list_compilation_jobs(
  NextToken = NULL,
  MaxResults = NULL,
  CreationTimeAfter = NULL,
  CreationTimeBefore = NULL,
  LastModifiedTimeAfter = NULL,
  LastModifiedTimeBefore = NULL,
  NameContains = NULL,
  StatusEquals = NULL,
  SortBy = NULL,
  SortOrder = NULL
)
}
\arguments{
\item{NextToken}{If the result of the previous
\code{\link[=sagemaker_list_compilation_jobs]{list_compilation_jobs}} request was
truncated, the response includes a \code{NextToken}. To retrieve the next set
of model compilation jobs, use the token in the next request.}

\item{MaxResults}{The maximum number of model compilation jobs to return in the response.}

\item{CreationTimeAfter}{A filter that returns the model compilation jobs that were created after
a specified time.}

\item{CreationTimeBefore}{A filter that returns the model compilation jobs that were created
before a specified time.}

\item{LastModifiedTimeAfter}{A filter that returns the model compilation jobs that were modified
after a specified time.}

\item{LastModifiedTimeBefore}{A filter that returns the model compilation jobs that were modified
before a specified time.}

\item{NameContains}{A filter that returns the model compilation jobs whose name contains a
specified string.}

\item{StatusEquals}{A filter that retrieves model compilation jobs with a specific
\code{CompilationJobStatus} status.}

\item{SortBy}{The field by which to sort results. The default is \code{CreationTime}.}

\item{SortOrder}{The sort order for results. The default is \code{Ascending}.}
}
\description{
Lists model compilation jobs that satisfy various filters.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_list_compilation_jobs/} for full documentation.
}
\keyword{internal}
