% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_send_pipeline_execution_step_failure}
\alias{sagemaker_send_pipeline_execution_step_failure}
\title{Notifies the pipeline that the execution of a callback step failed,
along with a message describing why}
\usage{
sagemaker_send_pipeline_execution_step_failure(
  CallbackToken,
  FailureReason = NULL,
  ClientRequestToken = NULL
)
}
\arguments{
\item{CallbackToken}{[required] The pipeline generated token from the Amazon SQS queue.}

\item{FailureReason}{A message describing why the step failed.}

\item{ClientRequestToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the operation. An idempotent operation completes no more
than one time.}
}
\description{
Notifies the pipeline that the execution of a callback step failed, along with a message describing why. When a callback step is run, the pipeline generates a callback token and includes the token in a message sent to Amazon Simple Queue Service (Amazon SQS).

See \url{https://paws-r.github.io/docs/sagemaker/send_pipeline_execution_step_failure.html} for full documentation.
}
\keyword{internal}
