% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_search}
\alias{sagemaker_search}
\title{Finds Amazon SageMaker resources that match a search query}
\usage{
sagemaker_search(
  Resource,
  SearchExpression = NULL,
  SortBy = NULL,
  SortOrder = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{Resource}{[required] The name of the Amazon SageMaker resource to search for.}

\item{SearchExpression}{A Boolean conditional statement. Resources must satisfy this condition
to be included in search results. You must provide at least one
subexpression, filter, or nested filter. The maximum number of recursive
\code{SubExpressions}, \code{NestedFilters}, and \code{Filters} that can be included in
a \code{SearchExpression} object is 50.}

\item{SortBy}{The name of the resource property used to sort the \code{SearchResults}. The
default is \code{LastModifiedTime}.}

\item{SortOrder}{How \code{SearchResults} are ordered. Valid values are \code{Ascending} or
\code{Descending}. The default is \code{Descending}.}

\item{NextToken}{If more than \code{MaxResults} resources match the specified
\code{SearchExpression}, the response includes a \code{NextToken}. The \code{NextToken}
can be passed to the next \code{SearchRequest} to continue retrieving
results.}

\item{MaxResults}{The maximum number of results to return.}
}
\description{
Finds Amazon SageMaker resources that match a search query. Matching resources are returned as a list of \code{SearchRecord} objects in the response. You can sort the search results by any resource property in a ascending or descending order.

See \url{https://paws-r.github.io/docs/sagemaker/search.html} for full documentation.
}
\keyword{internal}
