% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_monitoring_executions}
\alias{sagemaker_list_monitoring_executions}
\title{Returns list of all monitoring job executions}
\usage{
sagemaker_list_monitoring_executions(
  MonitoringScheduleName = NULL,
  EndpointName = NULL,
  SortBy = NULL,
  SortOrder = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  ScheduledTimeBefore = NULL,
  ScheduledTimeAfter = NULL,
  CreationTimeBefore = NULL,
  CreationTimeAfter = NULL,
  LastModifiedTimeBefore = NULL,
  LastModifiedTimeAfter = NULL,
  StatusEquals = NULL,
  MonitoringJobDefinitionName = NULL,
  MonitoringTypeEquals = NULL
)
}
\arguments{
\item{MonitoringScheduleName}{Name of a specific schedule to fetch jobs for.}

\item{EndpointName}{Name of a specific endpoint to fetch jobs for.}

\item{SortBy}{Whether to sort results by \code{Status}, \code{CreationTime}, \code{ScheduledTime}
field. The default is \code{CreationTime}.}

\item{SortOrder}{Whether to sort the results in \code{Ascending} or \code{Descending} order. The
default is \code{Descending}.}

\item{NextToken}{The token returned if the response is truncated. To retrieve the next
set of job executions, use it in the next request.}

\item{MaxResults}{The maximum number of jobs to return in the response. The default value
is 10.}

\item{ScheduledTimeBefore}{Filter for jobs scheduled before a specified time.}

\item{ScheduledTimeAfter}{Filter for jobs scheduled after a specified time.}

\item{CreationTimeBefore}{A filter that returns only jobs created before a specified time.}

\item{CreationTimeAfter}{A filter that returns only jobs created after a specified time.}

\item{LastModifiedTimeBefore}{A filter that returns only jobs modified after a specified time.}

\item{LastModifiedTimeAfter}{A filter that returns only jobs modified before a specified time.}

\item{StatusEquals}{A filter that retrieves only jobs with a specific status.}

\item{MonitoringJobDefinitionName}{Gets a list of the monitoring job runs of the specified monitoring job
definitions.}

\item{MonitoringTypeEquals}{A filter that returns only the monitoring job runs of the specified
monitoring type.}
}
\description{
Returns list of all monitoring job executions.

See \url{https://paws-r.github.io/docs/sagemaker/list_monitoring_executions.html} for full documentation.
}
\keyword{internal}
