% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_auto_ml_job}
\alias{sagemaker_create_auto_ml_job}
\title{Creates an Autopilot job}
\usage{
sagemaker_create_auto_ml_job(
  AutoMLJobName,
  InputDataConfig,
  OutputDataConfig,
  ProblemType = NULL,
  AutoMLJobObjective = NULL,
  AutoMLJobConfig = NULL,
  RoleArn,
  GenerateCandidateDefinitionsOnly = NULL,
  Tags = NULL,
  ModelDeployConfig = NULL
)
}
\arguments{
\item{AutoMLJobName}{[required] Identifies an Autopilot job. The name must be unique to your account and
is case-insensitive.}

\item{InputDataConfig}{[required] An array of channel objects that describes the input data and its
location. Each channel is a named input source. Similar to
\code{InputDataConfig} supported by . Format(s) supported: CSV, Parquet. A
minimum of 500 rows is required for the training dataset. There is not a
minimum number of rows required for the validation dataset.}

\item{OutputDataConfig}{[required] Provides information about encryption and the Amazon S3 output path
needed to store artifacts from an AutoML job. Format(s) supported: CSV.}

\item{ProblemType}{Defines the type of supervised learning available for the candidates.
For more information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/}{Amazon SageMaker Autopilot problem types and algorithm support}.}

\item{AutoMLJobObjective}{Defines the objective metric used to measure the predictive quality of
an AutoML job. You provide an AutoMLJobObjective$MetricName and
Autopilot infers whether to minimize or maximize it.}

\item{AutoMLJobConfig}{A collection of settings used to configure an AutoML job.}

\item{RoleArn}{[required] The ARN of the role that is used to access the data.}

\item{GenerateCandidateDefinitionsOnly}{Generates possible candidates without training the models. A candidate
is a combination of data preprocessors, algorithms, and algorithm
parameter settings.}

\item{Tags}{Each tag consists of a key and an optional value. Tag keys must be
unique per resource.}

\item{ModelDeployConfig}{Specifies how to generate the endpoint name for an automatic one-click
Autopilot model deployment.}
}
\description{
Creates an Autopilot job.

See \url{https://paws-r.github.io/docs/sagemaker/create_auto_ml_job.html} for full documentation.
}
\keyword{internal}
